/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.chorem.pollen.persistence.PollenPersistenceConfiguration;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollenFlywayService {
    private static final Logger log = LoggerFactory.getLogger(PollenFlywayService.class);
    private final PollenPersistenceConfiguration pollenPersistenceConfiguration;
    private static final String FLYWAY_BASELINE_VERSION = "flyway.baselineVersion";
    private String flywayBaselineVersion = null;
    private Configuration flywayConfiguration;

    public PollenFlywayService(PollenPersistenceConfiguration pollenPersistenceConfiguration) {
        this.pollenPersistenceConfiguration = pollenPersistenceConfiguration;
        this.init();
    }

    private void init() {
        Map<String, String> conf = this.pollenPersistenceConfiguration.getMigrationServiceConfiguration();
        if (conf.containsKey(FLYWAY_BASELINE_VERSION)) {
            this.flywayBaselineVersion = conf.get(FLYWAY_BASELINE_VERSION);
            if (StringUtils.isBlank((CharSequence)this.flywayBaselineVersion)) {
                throw new IllegalArgumentException("'flyway.baselineVersion' must not be empty");
            }
        }
        Map flywayParametersFromTopiaConfiguration = Maps.filterKeys(conf, key -> key.startsWith("flyway."));
        this.flywayConfiguration = this.newFlywayConfiguration(flywayParametersFromTopiaConfiguration);
        if (log.isInfoEnabled()) {
            log.info("flyway configuration {}", (Object)this.toString(this.flywayConfiguration));
        }
    }

    private ClassicConfiguration newFlywayConfiguration(Map<String, String> flywayParametersFromTopiaConfiguration) {
        ClassicConfiguration newFlywayConfiguration = new ClassicConfiguration();
        this.setDataSource(newFlywayConfiguration);
        this.setLocations(newFlywayConfiguration);
        newFlywayConfiguration.configure(flywayParametersFromTopiaConfiguration);
        this.doExtraConfiguration(newFlywayConfiguration);
        return newFlywayConfiguration;
    }

    private void setDataSource(ClassicConfiguration flywayConfiguration) {
        String url = this.pollenPersistenceConfiguration.getJdbcConnectionUrl();
        String user = this.pollenPersistenceConfiguration.getJdbcConnectionUser();
        String password = this.pollenPersistenceConfiguration.getJdbcConnectionPassword();
        flywayConfiguration.setDataSource(url, user, password);
    }

    public void initOnCreateSchema() {
        String baselineVersion;
        Flyway flyway = new Flyway(this.flywayConfiguration);
        Object[] allMigrations = flyway.info().all();
        if (ArrayUtils.isEmpty((Object[])allMigrations)) {
            log.info("Using {} version: {}", (Object)FLYWAY_BASELINE_VERSION, (Object)this.flywayBaselineVersion);
            baselineVersion = this.flywayBaselineVersion;
        } else {
            TreeSet treeSet = Sets.newTreeSet(Arrays.asList(allMigrations));
            MigrationInfo last = (MigrationInfo)Iterables.getLast((Iterable)treeSet);
            String version = last.getVersion().getVersion();
            log.info("Using highest migration version found: {}", (Object)version);
            baselineVersion = version;
        }
        ClassicConfiguration flywayConfigurationForInitOnCreateSchema = new ClassicConfiguration(this.flywayConfiguration);
        flywayConfigurationForInitOnCreateSchema.setBaselineVersion(MigrationVersion.fromVersion((String)baselineVersion));
        flywayConfigurationForInitOnCreateSchema.setBaselineDescription("schema creation called on application context by topia flyway service");
        if (log.isDebugEnabled()) {
            log.debug("baseline flyway to version {} with flyway configuration {}", (Object)baselineVersion, (Object)this.toString((Configuration)flywayConfigurationForInitOnCreateSchema));
        }
        Flyway flyway2 = new Flyway((Configuration)flywayConfigurationForInitOnCreateSchema);
        flyway2.baseline();
    }

    private String toString(Configuration flywayConfiguration) {
        return ReflectionToStringBuilder.reflectionToString((Object)flywayConfiguration);
    }

    public void runSchemaMigration() {
        ClassicConfiguration flywayConfigurationForMigration = new ClassicConfiguration(this.flywayConfiguration);
        if (this.flywayBaselineVersion == null) {
            log.debug("schema exists, no flywayInitVersion found, let suppose flyway is already initialized");
        } else {
            log.debug("schema exists, will ask flyway to init if necessary to version {}", (Object)this.flywayBaselineVersion);
            flywayConfigurationForMigration.setBaselineOnMigrate(Boolean.valueOf(true));
            flywayConfigurationForMigration.setBaselineVersion(MigrationVersion.fromVersion((String)this.flywayBaselineVersion));
        }
        log.info("schema exists, no target version specified, will run flyway migration for all existing versions");
        if (log.isInfoEnabled()) {
            log.info("run flyway migration with configuration {}", (Object)this.toString((Configuration)flywayConfigurationForMigration));
        }
        Flyway flyway = new Flyway((Configuration)flywayConfigurationForMigration);
        flyway.migrate();
        log.info("flyway migration done");
    }

    private void setLocations(ClassicConfiguration flywayConfiguration) {
        ArrayList locations = Lists.newArrayList((Object[])new String[]{"db/migration/common"});
        String jdbcUrl = this.pollenPersistenceConfiguration.getJdbcConnectionUrl();
        if (jdbcUrl.startsWith("jdbc:postgresql")) {
            locations.add("db/migration/postgresql");
        } else if (jdbcUrl.startsWith("jdbc:h2")) {
            locations.add("db/migration/h2");
        }
        String[] locationsArray = locations.toArray(new String[0]);
        flywayConfiguration.setLocationsAsStrings(locationsArray);
    }

    private void doExtraConfiguration(ClassicConfiguration flywayConfiguration) {
        flywayConfiguration.setTable("schema_version");
    }
}

