/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.PollenDao;
import org.chorem.pollen.persistence.PollenDaoSupplier;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.topia.HqlAndParametersBuilder;
import org.chorem.pollen.persistence.topia.QueryMissingOrderException;
import org.chorem.pollen.persistence.topia.TopiaException;
import org.chorem.pollen.persistence.topia.TopiaIdFactory;
import org.chorem.pollen.persistence.topia.TopiaNoResultException;
import org.chorem.pollen.persistence.topia.TopiaNonUniqueResultException;
import org.chorem.pollen.persistence.topia.internal.support.HibernateJpaSupport;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;
import org.chorem.pollen.persistence.topia.query.RunQueryStep;
import org.nuiton.util.pagination.PaginationOrder;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPollenDao<E extends PollenEntity>
implements PollenDao<E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPollenDao.class);
    protected static final Function<PaginationOrder, String> PAGINATION_ORDER_TO_HQL = input -> String.format("%s %s", input.getClause(), input.isDesc() ? "DESC" : "ASC");
    protected HibernateJpaSupport jpaSupport;
    protected PollenDaoSupplier daoSupplier;
    private static final String LIKE = "TRANSLATE(LOWER( %s ),'\u00e1\u00e0\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u00e8\u00e9\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u00ec\u00ed\u00ee\u00ef\u00ec\u0129\u012b\u012d\u1e29\u00f3\u00f4\u00f5\u00f6\u014d\u014f\u0151\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u00e4\u00e0\u00e1\u00e2\u00e3\u00e5\u00e6\u00e7\u0107\u0109\u010d\u00f6\u00f2\u00f3\u00f4\u00f5\u00f8\u00fc\u00f9\u00fa\u00fb\u00df\u00e9\u00e8\u00ea\u00eb\u00fd\u00f1\u00ee\u00ec\u00ed\u00ef\u015f','aaaaaaaaaeeeeeeeeeeiiiiiiiihooooooouuuuuuuuaaaaaaeccccoooooouuuuseeeeyniiiis')like LOWER( %s )";

    protected abstract Class<E> getEntityClass();

    public void init(HibernateJpaSupport jpaSupport, PollenDaoSupplier pollenDaoSupplier) {
        if (log.isDebugEnabled()) {
            log.debug("init dao for " + String.valueOf(this.getEntityClass()));
        }
        this.jpaSupport = jpaSupport;
        this.daoSupplier = pollenDaoSupplier;
    }

    @Override
    public E newInstance() {
        if (log.isTraceEnabled()) {
            log.trace("entityClass = " + String.valueOf(this.getEntityClass()));
        }
        Class<E> implementation = this.getEntityClass();
        try {
            return (E)((PollenEntity)implementation.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + String.valueOf(implementation));
        }
    }

    private E newInstance(Map<String, Object> properties) {
        E result = this.newInstance();
        try {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propertyName = e.getKey();
                Object value = e.getValue();
                PropertyUtils.setProperty(result, (String)propertyName, (Object)value);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        return result;
    }

    @Override
    public E create(E entity) {
        if (StringUtils.isBlank((CharSequence)entity.getTopiaId())) {
            String topiaId = TopiaIdFactory.newTopiaId(this.getEntityClass());
            entity.setTopiaId(topiaId);
        }
        this.jpaSupport.save(entity);
        return entity;
    }

    private static Map<String, Object> convertPropertiesArrayToMap(Object ... propertyNamesAndValues) throws IllegalArgumentException {
        int propertiesLength = propertyNamesAndValues.length;
        Preconditions.checkArgument((propertiesLength % 2 == 0 ? 1 : 0) != 0, (Object)("Wrong number of argument " + propertiesLength + ", you must have even number."));
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        int i = 0;
        while (i < propertyNamesAndValues.length) {
            Object aPropertyName = propertyNamesAndValues[i++];
            Object value = propertyNamesAndValues[i++];
            Preconditions.checkArgument((boolean)(aPropertyName instanceof String), (Object)("Argument at position [" + (i - 1) + "] should be a property name (says a String) but was " + String.valueOf(aPropertyName)));
            properties.put((String)aPropertyName, value);
        }
        return properties;
    }

    public static Map<String, Object> convertPropertiesArrayToMap(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) throws IllegalArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, propertyValue);
        properties.putAll(AbstractPollenDao.convertPropertiesArrayToMap(otherPropertyNamesAndValues));
        return properties;
    }

    protected E create(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = AbstractPollenDao.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        E result = this.newInstance(properties);
        this.create(result);
        return result;
    }

    @Override
    public E create() {
        E result = this.newInstance();
        this.create(result);
        return result;
    }

    @Override
    public E update(E entity) {
        this.jpaSupport.saveOrUpdate(entity);
        return entity;
    }

    @Override
    public void updateAll(Iterable<E> entities) {
        for (PollenEntity entity : entities) {
            this.update(entity);
        }
    }

    @Override
    public void delete(E entity) {
        this.jpaSupport.delete(entity);
        entity.notifyDeleted();
    }

    @Override
    public void deleteAll(Iterable<E> entities) {
        for (PollenEntity entity : entities) {
            this.delete(entity);
        }
    }

    protected HqlAndParametersBuilder<E> newHqlAndParametersBuilder() {
        return new HqlAndParametersBuilder<E>(this.getEntityClass());
    }

    private HqlAndParametersBuilder<E> getHqlForProperties(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = AbstractPollenDao.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        return this.getHqlForProperties(properties);
    }

    private HqlAndParametersBuilder<E> getHqlForProperties(Map<String, Object> properties) {
        HqlAndParametersBuilder<E> result = this.newHqlAndParametersBuilder();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            result.addEquals(property.getKey(), property.getValue());
        }
        return result;
    }

    protected InnerRunQueryStep<E> forHql(String hql) {
        Map<String, Object> properties = Collections.emptyMap();
        return this.forHql(hql, properties);
    }

    protected InnerRunQueryStep<E> forHql(String hql, Map<String, Object> hqlParameters) {
        boolean withOrderByClause = false;
        return new InnerRunQueryStep(this, true, withOrderByClause, hql, hqlParameters);
    }

    protected InnerAddCriteriaOrRunQueryStep<E> forProperties(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.getHqlForProperties(propertyName, propertyValue, otherPropertyNamesAndValues);
        return new InnerAddCriteriaOrRunQueryStep<E>(this, hqlAndParametersBuilder);
    }

    private InnerAddCriteriaOrRunQueryStep<E> newQueryBuilder() {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.newHqlAndParametersBuilder();
        return new InnerAddCriteriaOrRunQueryStep<E>(this, hqlAndParametersBuilder);
    }

    protected AddCriteriaOrRunQueryStep<E> forContains(String propertyName, Object propertyValue) {
        return this.newQueryBuilder().addContains(propertyName, propertyValue);
    }

    protected AddCriteriaOrRunQueryStep<E> forEquals(String propertyName, Object propertyValue) {
        return this.newQueryBuilder().addEquals(propertyName, propertyValue);
    }

    protected AddCriteriaOrRunQueryStep<E> forIn(String propertyName, Collection<?> propertyValues) {
        return this.newQueryBuilder().addIn(propertyName, propertyValues);
    }

    protected boolean exists(String hql, Map<String, Object> hqlParameters) {
        PollenEntity entity = (PollenEntity)this.jpaSupport.findAny(hql, hqlParameters);
        return entity != null;
    }

    protected long count(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkArgument((boolean)hql.toLowerCase().trim().startsWith("select count("), (Object)"Your HQL query must start with \"select count(\"");
        return (Long)this.findUnique(hql, hqlParameters);
    }

    protected <O> O findUnique(String hql, Map<String, Object> hqlParameters) throws TopiaNoResultException, TopiaNonUniqueResultException {
        O result = this.findUniqueOrNull(hql, hqlParameters);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <O> Optional<O> tryFindUnique(String hql, Map<String, Object> hqlParameters) throws TopiaNonUniqueResultException {
        O uniqueOrNull = this.findUniqueOrNull(hql, hqlParameters);
        return Optional.ofNullable(uniqueOrNull);
    }

    protected <O> O findUniqueOrNull(String hql, Map<String, Object> hqlParameters) throws TopiaNonUniqueResultException {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        return (O)this.jpaSupport.findUnique(hql, hqlParameters);
    }

    protected <O> Optional<O> tryFindFirst(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        O firstOrNull = this.findFirstOrNull(hql, hqlParameters);
        return Optional.ofNullable(firstOrNull);
    }

    private <O> O findFirstOrNull(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        if (!this.hqlContainsOrderBy(hql)) {
            throw new QueryMissingOrderException(hql);
        }
        return this.findAnyOrNull(hql, hqlParameters);
    }

    protected <O> Optional<O> tryFindAny(String hql, Map<String, Object> hqlParameters) {
        O anyOrNull = this.findAnyOrNull(hql, hqlParameters);
        return Optional.ofNullable(anyOrNull);
    }

    protected <O> O findAnyOrNull(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        return (O)this.jpaSupport.findAny(hql, hqlParameters);
    }

    protected <O> List<O> findAll(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        return this.jpaSupport.findAll(hql, hqlParameters);
    }

    protected <O> List<O> find(String hql, Map<String, Object> hqlParameters, int startIndex, int endIndex) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        return this.jpaSupport.find(hql, startIndex, endIndex, hqlParameters);
    }

    protected <O> List<O> find(String hql, Map<String, Object> hqlParameters, PaginationParameter page) {
        boolean pageContainsOrderClause;
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Preconditions.checkNotNull((Object)page);
        boolean hqlContainsOrderClause = this.hqlContainsOrderBy((String)hql);
        boolean bl = pageContainsOrderClause = !page.getOrderClauses().isEmpty();
        if (!hqlContainsOrderClause && !pageContainsOrderClause) {
            throw new QueryMissingOrderException((String)hql, page);
        }
        Preconditions.checkArgument((boolean)(hqlContainsOrderClause ^ pageContainsOrderClause), (Object)String.format("One 'order by' clause (and only one) must be specified. [orderByInHql=%b] [orderByInPage=%b]", hqlContainsOrderClause, pageContainsOrderClause));
        if (pageContainsOrderClause) {
            hql = (String)hql + " ORDER BY ";
            Iterable orderClauses = Iterables.transform((Iterable)page.getOrderClauses(), PAGINATION_ORDER_TO_HQL::apply);
            hql = (String)hql + Joiner.on((String)", ").join(orderClauses);
        }
        return this.jpaSupport.find((String)hql, page.getStartIndex(), page.getEndIndex(), hqlParameters);
    }

    protected <O> PaginationResult<O> findPage(String hql, Map<String, Object> hqlParameters, PaginationParameter page) {
        List<O> elements = this.find(hql, hqlParameters, page);
        Object countHql = "select count(topiaId) ";
        countHql = this.hqlStartsWithSelect(hql) ? (String)countHql + hql.substring(hql.toLowerCase().indexOf(" from ")) : (String)countHql + hql;
        if (this.hqlContainsOrderBy((String)countHql)) {
            countHql = ((String)countHql).substring(0, ((String)countHql).toLowerCase().indexOf("order by"));
        }
        long count = this.count((String)countHql, hqlParameters);
        return PaginationResult.of(elements, (long)count, (PaginationParameter)page);
    }

    @Override
    public AddCriteriaOrRunQueryStep<E> forTopiaIdEquals(String topiaId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topiaId), (Object)"given topiaId is blank");
        return this.forEquals("topiaId", topiaId);
    }

    @Override
    public List<E> findAll() {
        return this.newQueryBuilder().findAll();
    }

    @Override
    public long count() {
        return this.newQueryBuilder().count();
    }

    private boolean hqlContainsOrderBy(String hql) {
        return hql.toLowerCase().contains("order by");
    }

    private boolean hqlStartsWithSelect(String hql) {
        return hql.toLowerCase().trim().startsWith("select ");
    }

    protected String getFieldLikeInsensitive(String field1, String field2) {
        return String.format(LIKE, field1, field2);
    }

    protected String addQueryAttribute(Map<String, Object> args, String entityAttributeName, Object value) {
        String queryAttributeName;
        String baseAttributeName = entityAttributeName.replaceAll("[.]", "_");
        int index = 0;
        do {
            queryAttributeName = baseAttributeName + index;
            ++index;
        } while (args.containsKey(queryAttributeName));
        args.put(queryAttributeName, value);
        return queryAttributeName;
    }

    protected String getSearchClause(String alias, Map<String, Object> parameters, String entityAttributeName, String search) {
        String queryAttributeName = this.addQueryAttribute(parameters, entityAttributeName, "%" + StringUtils.stripAccents((String)search) + "%");
        return this.getFieldLikeInsensitive(alias + "." + entityAttributeName, ":" + queryAttributeName);
    }

    public static class InnerRunQueryStep<E extends PollenEntity>
    implements RunQueryStep<E> {
        protected final String hql;
        protected final Map<String, Object> hqlParameters;
        protected final AbstractPollenDao<E> dao;
        protected final boolean fromHql;
        protected final boolean withOrderByClause;
        protected final String hqlForFetchStep1;
        protected final String hqlForFetchStep2;

        protected InnerRunQueryStep(AbstractPollenDao<E> dao, boolean fromHql, boolean withOrderByClause, String hql, Map<String, Object> hqlParameters) {
            this(dao, fromHql, withOrderByClause, hql, hqlParameters, null, null);
        }

        protected InnerRunQueryStep(AbstractPollenDao<E> dao, boolean fromHql, boolean withOrderByClause, String hql, Map<String, Object> hqlParameters, String hqlForFetchStep1, String hqlForFetchStep2) {
            this.fromHql = fromHql;
            this.withOrderByClause = withOrderByClause;
            this.hql = hql;
            this.hqlParameters = hqlParameters;
            this.dao = dao;
            this.hqlForFetchStep1 = hqlForFetchStep1;
            this.hqlForFetchStep2 = hqlForFetchStep2;
        }

        @Override
        public boolean exists() {
            return this.dao.exists(this.hql, this.hqlParameters);
        }

        @Override
        public long count() {
            String hqlWithSelectClause = "select count(topiaId) " + this.hql;
            return this.dao.count(hqlWithSelectClause, this.hqlParameters);
        }

        @Override
        public E findUnique() throws TopiaNoResultException, TopiaNonUniqueResultException {
            return (E)((PollenEntity)this.dao.findUnique(this.hql, this.hqlParameters));
        }

        @Override
        public E findUniqueOrNull() throws TopiaNonUniqueResultException {
            return (E)((PollenEntity)this.dao.findUniqueOrNull(this.hql, this.hqlParameters));
        }

        @Override
        public Optional<E> tryFindUnique() throws TopiaNonUniqueResultException {
            return this.dao.tryFindUnique(this.hql, this.hqlParameters);
        }

        @Override
        public Optional<E> tryFindFirst() throws QueryMissingOrderException {
            return this.dao.tryFindFirst(this.hql, this.hqlParameters);
        }

        @Override
        public Optional<E> tryFindAny() {
            return this.dao.tryFindAny(this.hql, this.hqlParameters);
        }

        @Override
        public List<E> findAll() {
            return this.dao.findAll(this.hql, this.hqlParameters);
        }

        @Override
        public List<E> find(int startIndex, int endIndex) {
            List result;
            if (!Strings.isNullOrEmpty((String)this.hqlForFetchStep1) && !Strings.isNullOrEmpty((String)this.hqlForFetchStep2)) {
                List<String> step1ResultTopiaIds = this.dao.find(this.hqlForFetchStep1, this.hqlParameters, startIndex, endIndex);
                if (CollectionUtils.isEmpty(step1ResultTopiaIds)) {
                    result = Lists.newArrayList();
                } else {
                    HashMap step2Args = Maps.newHashMap();
                    step2Args.put("topiaIdsForFetch_", step1ResultTopiaIds);
                    List<E> entities = this.dao.forHql(this.hqlForFetchStep2, step2Args).findAll();
                    result = this.sortAccordingToIds(entities, step1ResultTopiaIds);
                }
            } else {
                result = this.dao.find(this.hql, this.hqlParameters, startIndex, endIndex);
            }
            return result;
        }

        @Override
        public PaginationResult<E> findPage(PaginationParameter page) {
            PaginationResult result;
            if (!Strings.isNullOrEmpty((String)this.hqlForFetchStep1) && !Strings.isNullOrEmpty((String)this.hqlForFetchStep2)) {
                List sortedEntities;
                PaginationResult pageResult = this.dao.findPage(this.hqlForFetchStep1, this.hqlParameters, page);
                List step1ResultTopiaIds = pageResult.getElements();
                if (CollectionUtils.isEmpty((Collection)step1ResultTopiaIds)) {
                    sortedEntities = Lists.newArrayList();
                } else {
                    HashMap step2Args = Maps.newHashMap();
                    step2Args.put("topiaIdsForFetch_", step1ResultTopiaIds);
                    List<E> entities = this.dao.forHql(this.hqlForFetchStep2, step2Args).findAll();
                    sortedEntities = this.sortAccordingToIds(entities, step1ResultTopiaIds);
                }
                result = PaginationResult.of((List)sortedEntities, (long)pageResult.getCount(), (PaginationParameter)pageResult.getCurrentPage());
            } else {
                result = this.dao.findPage(this.hql, this.hqlParameters, page);
            }
            return result;
        }

        private static <E extends PollenEntity> Function<E, String> getTopiaIdFunction() {
            return input -> input == null ? null : input.getTopiaId();
        }

        protected <O extends PollenEntity> List<O> sortAccordingToIds(List<O> entities, List<String> idsList) {
            ImmutableMap entitiesIndex = Maps.uniqueIndex(entities, InnerRunQueryStep.getTopiaIdFunction()::apply);
            Iterable transformed = Iterables.transform(idsList, ((Map)entitiesIndex)::get);
            return Lists.newArrayList((Iterable)transformed);
        }
    }

    public static class InnerAddCriteriaOrRunQueryStep<E extends PollenEntity>
    implements AddCriteriaOrRunQueryStep<E> {
        protected AbstractPollenDao<E> dao;
        protected HqlAndParametersBuilder<E> hqlAndParametersBuilder;

        protected InnerAddCriteriaOrRunQueryStep(AbstractPollenDao<E> dao, HqlAndParametersBuilder<E> hqlAndParametersBuilder) {
            this.dao = dao;
            this.hqlAndParametersBuilder = hqlAndParametersBuilder;
        }

        @Override
        public InnerRunQueryStep<E> setOrderByArguments(String ... orderByArguments) {
            this.hqlAndParametersBuilder.setOrderByArguments(orderByArguments);
            return this.getNextStep();
        }

        @Override
        public RunQueryStep<E> setOrderByArguments(Collection<PaginationOrder> paginationOrders) {
            this.hqlAndParametersBuilder.setOrderByArguments(paginationOrders);
            return this.getNextStep();
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addEquals(String property, Object value) {
            this.hqlAndParametersBuilder.addEquals(property, value);
            return this;
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addNotEquals(String property, Object value) {
            this.hqlAndParametersBuilder.addNotEquals(property, value);
            return this;
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addIn(String property, Collection<?> values) {
            this.hqlAndParametersBuilder.addIn(property, values);
            return this;
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addContains(String property, Object value) {
            this.hqlAndParametersBuilder.addContains(property, value);
            return this;
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addNull(String property) {
            this.hqlAndParametersBuilder.addNull(property);
            return this;
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addTopiaIdEquals(String property, String topiaId) {
            this.hqlAndParametersBuilder.addTopiaIdEquals(property, topiaId);
            return this;
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addTopiaIdIn(String property, Collection<String> topiaIds) {
            this.hqlAndParametersBuilder.addTopiaIdIn(property, topiaIds);
            return this;
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addTopiaIdNotEquals(String property, String topiaId) {
            this.hqlAndParametersBuilder.addTopiaIdNotEquals(property, topiaId);
            return this;
        }

        @Override
        public AddCriteriaOrRunQueryStep<E> addTopiaIdNotIn(String property, Collection<String> topiaIds) {
            this.hqlAndParametersBuilder.addTopiaIdNotIn(property, topiaIds);
            return this;
        }

        @Override
        public boolean exists() {
            return this.getNextStep().exists();
        }

        @Override
        public E findUniqueOrNull() {
            return this.getNextStep().findUniqueOrNull();
        }

        @Override
        public E findUnique() {
            return this.getNextStep().findUnique();
        }

        @Override
        public Optional<E> tryFindAny() {
            return this.getNextStep().tryFindAny();
        }

        @Override
        public Optional<E> tryFindFirst() {
            return this.getNextStep().tryFindFirst();
        }

        @Override
        public Optional<E> tryFindUnique() {
            return this.getNextStep().tryFindUnique();
        }

        @Override
        public List<E> findAll() {
            return this.getNextStep().findAll();
        }

        @Override
        public List<E> find(int startIndex, int endIndex) {
            return this.getNextStep().find(startIndex, endIndex);
        }

        @Override
        public PaginationResult<E> findPage(PaginationParameter page) {
            return this.getNextStep().findPage(page);
        }

        @Override
        public long count() {
            return this.getNextStep().count();
        }

        protected InnerRunQueryStep<E> getNextStep() {
            InnerRunQueryStep<E> nextStep;
            String hql = this.hqlAndParametersBuilder.getHql();
            Map<String, Object> hqlParameters = this.hqlAndParametersBuilder.getHqlParameters();
            boolean withOrderByClause = this.hqlAndParametersBuilder.isOrderByClausePresent();
            if (this.hqlAndParametersBuilder.hasFetchProperties()) {
                String hqlForFetchStep1 = this.hqlAndParametersBuilder.getHqlForFetchStep1();
                String hqlForFetchStep2 = this.hqlAndParametersBuilder.getHqlForFetchStep2();
                nextStep = new InnerRunQueryStep<E>(this.dao, false, withOrderByClause, hql, hqlParameters, hqlForFetchStep1, hqlForFetchStep2);
            } else {
                nextStep = new InnerRunQueryStep<E>(this.dao, false, withOrderByClause, hql, hqlParameters);
            }
            return nextStep;
        }
    }
}

