/*
 * Decompiled with CFR 0.152.
 */
package db.migration.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.persistence.topia.TopiaIdFactory;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V3_1_0_5__Extract_email_addresses
extends BaseJavaMigration {
    private static final Logger log = LoggerFactory.getLogger(V3_1_0_5__Extract_email_addresses.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(Context context) throws SQLException {
        Connection connection = context.getConnection();
        PreparedStatement insertStatement = null;
        Statement updateStatement = null;
        ResultSet resultSet = null;
        try {
            String emailAddress;
            String userTopiaId;
            connection.setAutoCommit(false);
            insertStatement = connection.prepareStatement("INSERT INTO POLLENUSEREMAILADDRESS (TOPIAID, TOPIAVERSION, TOPIACREATEDATE, EMAILADDRESS, ACTIVATIONTOKEN, POLLENUSER) VALUES (?, ?, ?, ?, ?, ?)");
            updateStatement = connection.prepareStatement("UPDATE pollenuser SET DEFAULTEMAILADDRESS = ? WHERE topiaid = ?");
            resultSet = connection.createStatement().executeQuery("SELECT u.topiaId, u.email, u.emailactivationtoken FROM pollenuser u");
            while (resultSet.next()) {
                userTopiaId = resultSet.getString(1);
                emailAddress = resultSet.getString(2);
                String emailTokenActivation = resultSet.getString(3);
                String addressTopiaId = TopiaIdFactory.newTopiaId(PollenUserEmailAddress.class);
                insertStatement.setString(1, addressTopiaId);
                insertStatement.setInt(2, 1);
                insertStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                insertStatement.setString(4, emailAddress);
                insertStatement.setString(5, emailTokenActivation);
                insertStatement.setString(6, userTopiaId);
                insertStatement.addBatch();
                updateStatement.setString(1, addressTopiaId);
                updateStatement.setString(2, userTopiaId);
                updateStatement.addBatch();
            }
            resultSet.close();
            resultSet = connection.createStatement().executeQuery("SELECT uc.pollenuser, uc.email FROM usercredential uc");
            while (resultSet.next()) {
                userTopiaId = resultSet.getString(1);
                emailAddress = resultSet.getString(2);
                if (!StringUtils.isNotBlank((CharSequence)emailAddress) || emailAddress.equals("null")) continue;
                String addressTopiaId = TopiaIdFactory.newTopiaId(PollenUserEmailAddress.class);
                insertStatement.setString(1, addressTopiaId);
                insertStatement.setInt(2, 1);
                insertStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                insertStatement.setString(4, emailAddress);
                insertStatement.setNull(5, 12);
                insertStatement.setString(6, userTopiaId);
                insertStatement.addBatch();
            }
            resultSet.close();
            insertStatement.executeBatch();
            updateStatement.executeBatch();
            connection.commit();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (insertStatement != null) {
                insertStatement.close();
            }
            if (updateStatement != null) {
                updateStatement.close();
            }
        }
        log.info("done !");
    }
}

