/*
 * #%L
 * Pollen :: Persistence
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

import java.util.List;

public class VoteDAOImpl<E extends Vote> extends VoteDAOAbstract<E> {

    public List<E> findAllVotes(Poll poll) throws TopiaException {

        Preconditions.checkNotNull(poll);

        String hql = "SELECT e FROM VoteImpl e, PollImpl p WHERE " +
                     "p = :p AND " +
                     "e IN ELEMENTS(p.vote) " +
                     "ORDER BY e.topiaCreateDate DESC";

        List<E> result = findAllByQuery(hql, "p", poll);

        return result;
    }

    public List<E> findAllVotesByPoll(Poll poll,
                                      TopiaPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(poll);
        Preconditions.checkNotNull(pager);

        String countHql = "SELECT COUNT(e) FROM " +
                          "VoteImpl e, PollImpl p WHERE " +
                          "p = :p AND e IN ELEMENTS(p.vote)";

        computeAndAddRecordsToPager(countHql, pager, "p", poll);

        String hql = "SELECT e FROM VoteImpl e, PollImpl p WHERE " +
                     "p = :p AND " +
                     "e IN ELEMENTS(p.vote) " +
                     "ORDER BY e.topiaCreateDate DESC";

        List<E> result = findAllByQueryAndPager(hql, pager, "p", poll);
        return result;
    }

    public E findVoteByPollAndVotingId(Poll poll, String votingId) throws TopiaException {

        String hql = "SELECT e FROM VoteImpl e, PollImpl p WHERE " +
                     "p = :p AND " +
                     "e in elements(p.vote) AND " +
                     "e.pollAccount.votingId = :v";

        E result = findByQuery(hql, "p", poll, "v", votingId);
        return result;
    }

    public E findByPollAndAccountId(Poll poll, String accountId) throws TopiaException {

        String hql = "SELECT e FROM VoteImpl e, PollImpl p WHERE " +
                     "p = :p AND " +
                     "e in elements(p.vote) AND " +
                     "e.pollAccount.accountId = :a";

        E result = findByQuery(hql,"p", poll,  "a", accountId);
        return result;
    }
}
