/*
 * #%L
 * Pollen :: Persistence
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.TopiaException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommentDAOImpl<E extends Comment> extends CommentDAOAbstract<E> {

    public List<Comment> findAllComments(String pollId) throws TopiaException {

        Preconditions.checkNotNull(pollId);

        PollDAO dao = PollenDAOHelper.getPollDAO(context);
        Poll poll = dao.findByPollId(pollId);
        return poll == null ? Collections.<Comment>emptyList() : new ArrayList<Comment>(poll.getComment());

    }
}
