/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.services.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.Request;
import org.chenillekit.tapestry.core.ChenilleKitCoreConstants;
import org.chenillekit.tapestry.core.services.URIAssetAliasManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIAssetAliasManagerImpl
implements URIAssetAliasManager {
    private final Request request;
    private final Map<String, String> aliasToPathPrefix = CollectionFactory.newMap();
    private final Map<String, String> pathPrefixToAlias = CollectionFactory.newMap();
    private final List<String> sortedAliases;
    private final List<String> sortedPathPrefixes;

    public URIAssetAliasManagerImpl(Request request, Map<String, String> configuration) {
        this.request = request;
        for (Map.Entry<String, String> e : configuration.entrySet()) {
            String alias = this.withSlash(e.getKey());
            String path = this.withSlash(e.getValue());
            this.aliasToPathPrefix.put(alias, path);
            this.pathPrefixToAlias.put(path, alias);
        }
        Comparator<String> sortDescendingByLength = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        };
        this.sortedAliases = CollectionFactory.newList(this.aliasToPathPrefix.keySet());
        Collections.sort(this.sortedAliases, sortDescendingByLength);
        this.sortedPathPrefixes = CollectionFactory.newList(this.aliasToPathPrefix.values());
        Collections.sort(this.sortedPathPrefixes, sortDescendingByLength);
    }

    private String withSlash(String input) {
        if (input.endsWith("/")) {
            return input;
        }
        return input + "/";
    }

    @Override
    public String toClientURL(String resourcePath) {
        return this.toCompleteClientURI(resourcePath);
    }

    private String toCompleteClientURI(String resourcePath) {
        StringBuilder builder = new StringBuilder(this.request.getContextPath());
        builder.append(ChenilleKitCoreConstants.URI_PATH_PREFIX);
        for (String pathPrefix : this.sortedPathPrefixes) {
            if (!resourcePath.startsWith(pathPrefix)) continue;
            String alias = this.pathPrefixToAlias.get(pathPrefix);
            builder.append(alias);
            builder.append(resourcePath.substring(pathPrefix.length()));
            return builder.toString();
        }
        builder.append(resourcePath);
        return builder.toString();
    }

    @Override
    public String toResourcePath(String clientURL) {
        String basePath = clientURL.substring(ChenilleKitCoreConstants.URI_PATH_PREFIX.length());
        for (String alias : this.sortedAliases) {
            if (!basePath.startsWith(alias)) continue;
            return this.aliasToPathPrefix.get(alias) + basePath.substring(alias.length());
        }
        return basePath;
    }
}

