/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Service;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;

public class NumberFormat {
    @Inject
    private Logger logger;
    @Parameter(required=true, defaultPrefix="prop")
    private Number value;
    @Parameter(required=false, defaultPrefix="literal", value="#,##0.0#;(#,##0.0#)")
    private String mask;
    @Inject
    @Service(value="Request")
    private Request request;

    private String getFormatedValue() {
        try {
            DecimalFormat numberFormat = new DecimalFormat(this.mask, new DecimalFormatSymbols(this.request.getLocale()));
            return numberFormat.format(this.value);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            return this.value.toString();
        }
    }

    void beginRender(MarkupWriter writer) {
        if (this.value != null) {
            writer.write(this.getFormatedValue());
        }
    }
}

