/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.TextStreamResponse;

@SupportsInformalParameters
@Import(library={"${tapestry.scriptaculous}/controls.js", "InPlaceEditor.js"})
public class InPlaceEditor
implements ClientElement {
    public static final String SAVE_EVENT = "save";
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(required=true, principal=true)
    private String value;
    @Parameter(value="20", required=false, defaultPrefix="prop")
    private int size;
    @Parameter(required=false)
    private List<?> context;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private Request request;
    private String assignedClientId;
    private Object[] contextArray;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
        this.contextArray = this.context == null ? new Object[]{} : this.context.toArray();
    }

    void beginRender(MarkupWriter writer) {
        writer.element("span", new Object[]{"id", this.getClientId()});
        if (this.value != null && this.value.length() > 0) {
            writer.write(this.value);
        } else {
            writer.writeRaw(this.messages.get("empty"));
        }
    }

    void afterRender(MarkupWriter writer) {
        Link link = this.resources.createEventLink("action", this.contextArray);
        JSONObject spec = new JSONObject();
        writer.end();
        spec.put("clientId", (Object)this.getClientId());
        spec.put("href", (Object)link.toURI());
        JSONObject opts = new JSONObject();
        opts.put("cancelControl", (Object)"button");
        opts.put("cancelText", (Object)this.messages.get("cancelbutton"));
        opts.put("clickToEditText", (Object)this.messages.get("title"));
        opts.put("savingText", (Object)this.messages.get("saving"));
        opts.put("okText", (Object)this.messages.get("savebutton"));
        opts.put("okText", (Object)this.messages.get("savebutton"));
        opts.put("htmlResponse", (Object)Boolean.TRUE);
        opts.put("size", (Object)this.size);
        opts.put("stripLoadedTextTags", (Object)Boolean.TRUE);
        spec.put("options", (Object)opts);
        this.javascriptSupport.addInitializerCall("ckinplaceeditor", spec);
    }

    StreamResponse onAction(String value) throws UnsupportedEncodingException {
        String valueText = this.request.getParameter("value");
        this.resources.triggerEvent(SAVE_EVENT, new Object[]{value, valueText}, null);
        if (valueText == null || valueText.length() == 0) {
            valueText = this.messages.get("empty");
        }
        return new TextStreamResponse("text/html", new String(valueText.getBytes("UTF8")));
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

