/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.services.impl;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.internal.services.ContextResource;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.Context;
import org.chenillekit.image.services.ImageService;
import org.chenillekit.tapestry.core.ChenilleKitCoreConstants;
import org.chenillekit.tapestry.core.services.ThumbNailService;
import org.slf4j.Logger;

public class ThumbNailServiceImpl
implements ThumbNailService {
    private Logger logger;
    private ImageService imageService;
    private File thumbnailDirectory;
    private Context context;
    private AssetFactory assetFactory;

    public ThumbNailServiceImpl(Logger logger, ImageService imageService, Context context, AssetFactory assetFactory) {
        this.logger = logger;
        this.imageService = imageService;
        this.context = context;
        this.assetFactory = assetFactory;
        this.thumbnailDirectory = context.getRealFile(ChenilleKitCoreConstants.__THUMBNAL_DIRECTORY__);
        if (!this.thumbnailDirectory.exists()) {
            throw new RuntimeException("path: '" + this.thumbnailDirectory.getAbsolutePath() + "' not found.");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("thumbnail location: {}", (Object)this.thumbnailDirectory.getPath());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Asset convertToThumbnail(Asset originalAsset, int height, float quality) {
        Asset asset;
        block11: {
            FileOutputStream output = null;
            String thumbnailFileName = String.valueOf(this.buildChecksumFromURI(originalAsset.toClientURL(), height, quality).getValue());
            try {
                File outputFile;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("original image: {}", (Object)originalAsset.toClientURL());
                }
                if (!(outputFile = new File(this.thumbnailDirectory.getAbsolutePath() + "/" + thumbnailFileName)).exists()) {
                    output = new FileOutputStream(outputFile, false);
                    BufferedImage bufferedImage = this.imageService.scaleImage(originalAsset.getResource(), height);
                    this.imageService.reduceImageQuality(bufferedImage, quality, (OutputStream)output);
                    output.flush();
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("cached thumbnail '{}'", (Object)outputFile.toURL().toExternalForm());
                }
                ContextResource thumbRes = new ContextResource(this.context, ChenilleKitCoreConstants.__THUMBNAL_DIRECTORY__ + "/" + thumbnailFileName);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("thumbnailed image: {}", (Object)thumbRes.toURL().toExternalForm());
                }
                asset = this.assetFactory.createAsset((Resource)thumbRes);
                if (output == null) break block11;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new RuntimeException(e);
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        InternalUtils.close(output);
                    }
                    throw throwable;
                }
            }
            InternalUtils.close((Closeable)output);
        }
        return asset;
    }

    public String getThumbnailPath() {
        return this.thumbnailDirectory.getAbsolutePath();
    }

    private Checksum buildChecksumFromURI(String clientURL, int height, float quality) {
        CRC32 checksum = new CRC32();
        checksum.update(String.format("%s_%d_%f", clientURL, height, Float.valueOf(quality)).getBytes());
        return checksum;
    }
}

