/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.AssetSource;
import org.chenillekit.tapestry.core.services.ThumbNailService;

@SupportsInformalParameters
@IncludeJavaScriptLibrary(value={"../Chenillekit.js", "ThumbNail.js"})
public class ThumbNail
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String _clientId;
    @Parameter(name="asset", required=true, defaultPrefix="literal")
    private Object _assetObject;
    @Parameter(required=true, defaultPrefix="prop")
    private int _thumbHeight;
    @Parameter(value="80", required=false, defaultPrefix="prop")
    private float _quality;
    @Parameter(value="false", required=false, defaultPrefix="prop")
    private boolean _onClickAction;
    private String _assignedClientId;
    @Environmental
    private RenderSupport _pageRenderSupport;
    @Inject
    private ComponentResources _resources;
    @Inject
    private AssetSource _assetSource;
    @Inject
    private ThumbNailService _thumbNailService;
    private Asset _asset;

    void setupRender() {
        this._assignedClientId = this._pageRenderSupport.allocateClientId(this._clientId);
        if (this._assetObject instanceof String) {
            this._asset = this._assetSource.getAsset(this._resources.getBaseResource(), (String)this._assetObject, null);
        } else if (this._assetObject instanceof Asset) {
            this._asset = (Asset)this._assetObject;
        } else {
            throw new RuntimeException("parameter 'asset' neither a string nor an asset object");
        }
    }

    void beginRender(MarkupWriter writer) {
        writer.element("img", new Object[]{"id", this.getClientId(), "src", this.generateThumbNail().toClientURL()});
        this._resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
        if (this._onClickAction) {
            this._pageRenderSupport.addScript("new Ck.ThumbNail('%s', '%s');", new Object[]{this.getClientId(), this._asset.toClientURL()});
        }
    }

    private Asset generateThumbNail() {
        return this._thumbNailService.convertToThumbnail(this._asset, this._thumbHeight, this._quality);
    }

    public String getClientId() {
        return this._assignedClientId;
    }
}

