/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.google.services.impl;

import java.io.UnsupportedEncodingException;
import java.net.ProxySelector;
import java.net.URLEncoder;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.slf4j.Logger;

public abstract class AbstractGoogleService {
    private final Logger logger;
    private final String referer;
    private final String proxy;
    private final int timeout;
    private final String googleKey;
    private ProxySelector proxySelector;

    protected AbstractGoogleService(Logger logger, String googleKey, int timeout, String referer, String proxy) {
        Defense.notNull((Object)googleKey, (String)"googleKey");
        this.googleKey = googleKey;
        this.timeout = timeout;
        this.referer = referer;
        this.proxy = proxy;
        this.logger = logger;
        this.initService();
    }

    private void initService() {
        this.proxySelector = ProxySelector.getDefault();
    }

    protected String getEncodedString(String source) throws UnsupportedEncodingException {
        if (source == null) {
            return "";
        }
        return URLEncoder.encode(source.replace(' ', '+'), "UTF-8");
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getReferer() {
        return this.referer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getKey() {
        return this.googleKey;
    }
}

