/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import morfologik.stemming.DictionaryAttribute;
import morfologik.stemming.DictionaryMetadataBuilder;
import morfologik.stemming.EncoderType;

public final class DictionaryMetadata {
    private static Map<DictionaryAttribute, String> DEFAULT_ATTRIBUTES = new DictionaryMetadataBuilder().frequencyIncluded().ignorePunctuation().ignoreNumbers().ignoreCamelCase().ignoreAllUppercase().ignoreDiacritics().convertCase().supportRunOnWords().toMap();
    private static EnumSet<DictionaryAttribute> REQUIRED_ATTRIBUTES = EnumSet.of(DictionaryAttribute.SEPARATOR, DictionaryAttribute.ENCODER, DictionaryAttribute.ENCODING);
    private byte separator;
    private char separatorChar;
    private String encoding;
    private Charset charset;
    private Locale locale = Locale.getDefault();
    private LinkedHashMap<String, List<String>> replacementPairs = new LinkedHashMap();
    private LinkedHashMap<String, String> inputConversion = new LinkedHashMap();
    private LinkedHashMap<String, String> outputConversion = new LinkedHashMap();
    private LinkedHashMap<Character, List<Character>> equivalentChars = new LinkedHashMap();
    private final EnumMap<DictionaryAttribute, String> attributes;
    private final EnumMap<DictionaryAttribute, Boolean> boolAttributes = new EnumMap(DictionaryAttribute.class);
    private EncoderType encoderType;
    public static final String METADATA_FILE_EXTENSION = "info";

    public Map<DictionaryAttribute, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte getSeparator() {
        return this.separator;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public LinkedHashMap<String, String> getInputConversionPairs() {
        return this.inputConversion;
    }

    public LinkedHashMap<String, String> getOutputConversionPairs() {
        return this.outputConversion;
    }

    public LinkedHashMap<String, List<String>> getReplacementPairs() {
        return this.replacementPairs;
    }

    public LinkedHashMap<Character, List<Character>> getEquivalentChars() {
        return this.equivalentChars;
    }

    public boolean isFrequencyIncluded() {
        return this.boolAttributes.get((Object)DictionaryAttribute.FREQUENCY_INCLUDED);
    }

    public boolean isIgnoringPunctuation() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_PUNCTUATION);
    }

    public boolean isIgnoringNumbers() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_NUMBERS);
    }

    public boolean isIgnoringCamelCase() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_CAMEL_CASE);
    }

    public boolean isIgnoringAllUppercase() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_ALL_UPPERCASE);
    }

    public boolean isIgnoringDiacritics() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_DIACRITICS);
    }

    public boolean isConvertingCase() {
        return this.boolAttributes.get((Object)DictionaryAttribute.CONVERT_CASE);
    }

    public boolean isSupportingRunOnWords() {
        return this.boolAttributes.get((Object)DictionaryAttribute.RUN_ON_WORDS);
    }

    public DictionaryMetadata(Map<DictionaryAttribute, String> attrs) {
        this.attributes = new EnumMap(DictionaryAttribute.class);
        this.attributes.putAll(attrs);
        EnumMap<DictionaryAttribute, String> attributeMap = new EnumMap<DictionaryAttribute, String>(DEFAULT_ATTRIBUTES);
        attributeMap.putAll(attrs);
        EnumSet<DictionaryAttribute> requiredAttributes = EnumSet.copyOf(REQUIRED_ATTRIBUTES);
        block14: for (Map.Entry<DictionaryAttribute, String> e : attributeMap.entrySet()) {
            requiredAttributes.remove((Object)e.getKey());
            Object value = e.getKey().fromString(e.getValue());
            switch (e.getKey()) {
                case ENCODING: {
                    this.encoding = e.getValue();
                    if (!Charset.isSupported(this.encoding)) {
                        throw new IllegalArgumentException("Encoding not supported on this JVM: " + this.encoding);
                    }
                    this.charset = (Charset)value;
                    continue block14;
                }
                case SEPARATOR: {
                    this.separatorChar = ((Character)value).charValue();
                    continue block14;
                }
                case LOCALE: {
                    this.locale = (Locale)value;
                    continue block14;
                }
                case ENCODER: {
                    this.encoderType = (EncoderType)((Object)value);
                    continue block14;
                }
                case INPUT_CONVERSION: {
                    LinkedHashMap gvalue;
                    this.inputConversion = gvalue = (LinkedHashMap)value;
                    continue block14;
                }
                case OUTPUT_CONVERSION: {
                    LinkedHashMap gvalue;
                    this.outputConversion = gvalue = (LinkedHashMap)value;
                    continue block14;
                }
                case REPLACEMENT_PAIRS: {
                    LinkedHashMap gvalue;
                    this.replacementPairs = gvalue = (LinkedHashMap)value;
                    continue block14;
                }
                case EQUIVALENT_CHARS: {
                    LinkedHashMap gvalue;
                    this.equivalentChars = gvalue = (LinkedHashMap)value;
                    continue block14;
                }
                case IGNORE_PUNCTUATION: 
                case IGNORE_NUMBERS: 
                case IGNORE_CAMEL_CASE: 
                case IGNORE_ALL_UPPERCASE: 
                case IGNORE_DIACRITICS: 
                case CONVERT_CASE: 
                case RUN_ON_WORDS: 
                case FREQUENCY_INCLUDED: {
                    this.boolAttributes.put((DictionaryAttribute)((Enum)e.getKey()), (Boolean)value);
                    continue block14;
                }
                case AUTHOR: 
                case LICENSE: 
                case CREATION_DATE: {
                    e.getKey().fromString(e.getValue());
                    continue block14;
                }
            }
            throw new RuntimeException("Unexpected code path (attribute should be handled but is not): " + (Object)((Object)e.getKey()));
        }
        if (!requiredAttributes.isEmpty()) {
            throw new IllegalArgumentException("At least one the required attributes was not provided: " + requiredAttributes.toString());
        }
        CharsetEncoder encoder = this.getEncoder();
        try {
            ByteBuffer encoded = encoder.encode(CharBuffer.wrap(new char[]{this.separatorChar}));
            if (encoded.remaining() > 1) {
                throw new IllegalArgumentException("Separator character is not a single byte in encoding " + this.encoding + ": " + this.separatorChar);
            }
            this.separator = encoded.get();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Separator character cannot be converted to a byte in " + this.encoding + ": " + this.separatorChar, e);
        }
    }

    public CharsetDecoder getDecoder() {
        try {
            return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException("FSA's encoding charset is not supported: " + this.encoding);
        }
    }

    public CharsetEncoder getEncoder() {
        try {
            return this.charset.newEncoder();
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException("FSA's encoding charset is not supported: " + this.encoding);
        }
    }

    public EncoderType getSequenceEncoderType() {
        return this.encoderType;
    }

    public char getSeparatorAsChar() {
        return this.separatorChar;
    }

    public static DictionaryMetadataBuilder builder() {
        return new DictionaryMetadataBuilder();
    }

    public static String getExpectedMetadataFileName(String dictionaryFile) {
        int dotIndex = dictionaryFile.lastIndexOf(46);
        String featuresName = dotIndex >= 0 ? dictionaryFile.substring(0, dotIndex) + "." + METADATA_FILE_EXTENSION : dictionaryFile + "." + METADATA_FILE_EXTENSION;
        return featuresName;
    }

    public static Path getExpectedMetadataLocation(Path dictionary) {
        return dictionary.resolveSibling(DictionaryMetadata.getExpectedMetadataFileName(dictionary.getFileName().toString()));
    }

    public static DictionaryMetadata read(InputStream metadataStream) throws IOException {
        HashMap<DictionaryAttribute, String> map = new HashMap<DictionaryAttribute, String>();
        Properties properties = new Properties();
        properties.load(new InputStreamReader(metadataStream, "UTF-8"));
        if (!properties.containsKey(DictionaryAttribute.ENCODER.propertyName)) {
            boolean hasDeprecated = properties.containsKey("fsa.dict.uses-suffixes") || properties.containsKey("fsa.dict.uses-infixes") || properties.containsKey("fsa.dict.uses-prefixes");
            boolean usesSuffixes = Boolean.valueOf(properties.getProperty("fsa.dict.uses-suffixes", "true"));
            boolean usesPrefixes = Boolean.valueOf(properties.getProperty("fsa.dict.uses-prefixes", "false"));
            boolean usesInfixes = Boolean.valueOf(properties.getProperty("fsa.dict.uses-infixes", "false"));
            EncoderType encoder = usesInfixes ? EncoderType.INFIX : (usesPrefixes ? EncoderType.PREFIX : (usesSuffixes ? EncoderType.SUFFIX : EncoderType.NONE));
            if (!hasDeprecated) {
                throw new IOException("Use an explicit " + DictionaryAttribute.ENCODER.propertyName + "=" + encoder.name() + " metadata key: ");
            }
            throw new IOException("Deprecated encoder keys in metadata. Use " + DictionaryAttribute.ENCODER.propertyName + "=" + encoder.name());
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(DictionaryAttribute.fromPropertyName(key), properties.getProperty(key));
        }
        return new DictionaryMetadata(map);
    }

    public void write(Writer writer) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<DictionaryAttribute, String> e : this.getAttributes().entrySet()) {
            properties.setProperty(e.getKey().propertyName, e.getValue());
        }
        properties.store(writer, "# " + this.getClass().getName());
    }
}

