// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_stitching.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_objdetect.*;
import static org.bytedeco.opencv.global.opencv_objdetect.*;
import org.bytedeco.opencv.opencv_video.*;
import static org.bytedeco.opencv.global.opencv_video.*;
import org.bytedeco.opencv.opencv_ml.*;
import static org.bytedeco.opencv.global.opencv_ml.*;
import org.bytedeco.opencv.opencv_shape.*;
import static org.bytedeco.opencv.global.opencv_shape.*;
import org.bytedeco.opencv.opencv_xfeatures2d.*;
import static org.bytedeco.opencv.global.opencv_xfeatures2d.*;

public class opencv_stitching extends org.bytedeco.opencv.presets.opencv_stitching {
    static { Loader.load(); }

// Parsed from <opencv2/stitching/detail/warpers.hpp>

 /*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_WARPERS_HPP
// #define OPENCV_STITCHING_WARPERS_HPP

// #include "opencv2/core.hpp"
// #include "opencv2/core/cuda.hpp"
// #include "opencv2/imgproc.hpp"
// #include "opencv2/opencv_modules.hpp"
// Targeting ../opencv_stitching/RotationWarper.java


// Targeting ../opencv_stitching/ProjectorBase.java


// Targeting ../opencv_stitching/PlaneProjector.java


// Targeting ../opencv_stitching/DetailPlaneWarper.java


// Targeting ../opencv_stitching/AffineWarper.java


// Targeting ../opencv_stitching/SphericalProjector.java


// Targeting ../opencv_stitching/DetailSphericalWarper.java


// Targeting ../opencv_stitching/CylindricalProjector.java


// Targeting ../opencv_stitching/DetailCylindricalWarper.java


// Targeting ../opencv_stitching/FisheyeProjector.java


// Targeting ../opencv_stitching/DetailFisheyeWarper.java


// Targeting ../opencv_stitching/StereographicProjector.java


// Targeting ../opencv_stitching/DetailStereographicWarper.java


// Targeting ../opencv_stitching/CompressedRectilinearProjector.java


// Targeting ../opencv_stitching/DetailCompressedRectilinearWarper.java


// Targeting ../opencv_stitching/CompressedRectilinearPortraitProjector.java


// Targeting ../opencv_stitching/DetailCompressedRectilinearPortraitWarper.java


// Targeting ../opencv_stitching/PaniniProjector.java


// Targeting ../opencv_stitching/DetailPaniniWarper.java


// Targeting ../opencv_stitching/PaniniPortraitProjector.java


// Targeting ../opencv_stitching/DetailPaniniPortraitWarper.java


// Targeting ../opencv_stitching/MercatorProjector.java


// Targeting ../opencv_stitching/DetailMercatorWarper.java


// Targeting ../opencv_stitching/TransverseMercatorProjector.java


// Targeting ../opencv_stitching/DetailTransverseMercatorWarper.java


// Targeting ../opencv_stitching/DetailPlaneWarperGpu.java


// Targeting ../opencv_stitching/DetailSphericalWarperGpu.java


// Targeting ../opencv_stitching/DetailCylindricalWarperGpu.java


// Targeting ../opencv_stitching/SphericalPortraitProjector.java


// Targeting ../opencv_stitching/SphericalPortraitWarper.java


// Targeting ../opencv_stitching/CylindricalPortraitProjector.java


// Targeting ../opencv_stitching/CylindricalPortraitWarper.java


// Targeting ../opencv_stitching/PlanePortraitProjector.java


// Targeting ../opencv_stitching/PlanePortraitWarper.java



/** \} stitching_warp */

 // namespace detail
 // namespace cv

// #include "warpers_inl.hpp"

// #endif // OPENCV_STITCHING_WARPERS_HPP


// Parsed from <opencv2/stitching/detail/matchers.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_MATCHERS_HPP
// #define OPENCV_STITCHING_MATCHERS_HPP

// #include "opencv2/core.hpp"
// #include "opencv2/features2d.hpp"

// #include "opencv2/opencv_modules.hpp"
// Targeting ../opencv_stitching/ImageFeatures.java


/** \brief
<p>
@param featuresFinder
@param images
@param features
@param masks
*/
@Namespace("cv::detail") public static native void computeImageFeatures(
    @Ptr Feature2D featuresFinder,
    @ByVal MatVector images,
    @StdVector ImageFeatures features,
    @ByVal(nullValue = "cv::InputArrayOfArrays(cv::noArray())") MatVector masks);
@Namespace("cv::detail") public static native void computeImageFeatures(
    @Ptr Feature2D featuresFinder,
    @ByVal MatVector images,
    @StdVector ImageFeatures features);
@Namespace("cv::detail") public static native void computeImageFeatures(
    @Ptr Feature2D featuresFinder,
    @ByVal UMatVector images,
    @StdVector ImageFeatures features,
    @ByVal(nullValue = "cv::InputArrayOfArrays(cv::noArray())") UMatVector masks);
@Namespace("cv::detail") public static native void computeImageFeatures(
    @Ptr Feature2D featuresFinder,
    @ByVal UMatVector images,
    @StdVector ImageFeatures features);
@Namespace("cv::detail") public static native void computeImageFeatures(
    @Ptr Feature2D featuresFinder,
    @ByVal GpuMatVector images,
    @StdVector ImageFeatures features,
    @ByVal(nullValue = "cv::InputArrayOfArrays(cv::noArray())") GpuMatVector masks);
@Namespace("cv::detail") public static native void computeImageFeatures(
    @Ptr Feature2D featuresFinder,
    @ByVal GpuMatVector images,
    @StdVector ImageFeatures features);

/** \brief
<p>
@param featuresFinder
@param image
@param features
@param mask
*/
@Namespace("cv::detail") public static native @Name("computeImageFeatures") void computeImageFeatures2(
    @Ptr Feature2D featuresFinder,
    @ByVal Mat image,
    @ByRef ImageFeatures features,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::detail") public static native @Name("computeImageFeatures") void computeImageFeatures2(
    @Ptr Feature2D featuresFinder,
    @ByVal Mat image,
    @ByRef ImageFeatures features);
@Namespace("cv::detail") public static native @Name("computeImageFeatures") void computeImageFeatures2(
    @Ptr Feature2D featuresFinder,
    @ByVal UMat image,
    @ByRef ImageFeatures features,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::detail") public static native @Name("computeImageFeatures") void computeImageFeatures2(
    @Ptr Feature2D featuresFinder,
    @ByVal UMat image,
    @ByRef ImageFeatures features);
@Namespace("cv::detail") public static native @Name("computeImageFeatures") void computeImageFeatures2(
    @Ptr Feature2D featuresFinder,
    @ByVal GpuMat image,
    @ByRef ImageFeatures features,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::detail") public static native @Name("computeImageFeatures") void computeImageFeatures2(
    @Ptr Feature2D featuresFinder,
    @ByVal GpuMat image,
    @ByRef ImageFeatures features);
// Targeting ../opencv_stitching/MatchesInfo.java


// Targeting ../opencv_stitching/FeaturesMatcher.java


// Targeting ../opencv_stitching/BestOf2NearestMatcher.java


// Targeting ../opencv_stitching/BestOf2NearestRangeMatcher.java


// Targeting ../opencv_stitching/AffineBestOf2NearestMatcher.java



/** \} stitching_match */

 // namespace detail
 // namespace cv

// #endif // OPENCV_STITCHING_MATCHERS_HPP


// Parsed from <opencv2/stitching/detail/util.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_UTIL_HPP
// #define OPENCV_STITCHING_UTIL_HPP

// #include <list>
// #include "opencv2/core.hpp"
// Targeting ../opencv_stitching/DisjointSets.java


// Targeting ../opencv_stitching/GraphEdge.java




// Targeting ../opencv_stitching/Graph.java




//////////////////////////////////////////////////////////////////////////////
// Auxiliary functions

@Namespace("cv::detail") public static native @Cast("bool") boolean overlapRoi(@ByVal Point tl1, @ByVal Point tl2, @ByVal Size sz1, @ByVal Size sz2, @ByRef Rect roi);
@Namespace("cv::detail") public static native @ByVal Rect resultRoi(@Const @ByRef PointVector corners, @Const @ByRef UMatVector images);
@Namespace("cv::detail") public static native @ByVal Rect resultRoi(@Const @ByRef PointVector corners, @Const @ByRef SizeVector sizes);
@Namespace("cv::detail") public static native @ByVal Rect resultRoiIntersection(@Const @ByRef PointVector corners, @Const @ByRef SizeVector sizes);
@Namespace("cv::detail") public static native @ByVal Point resultTl(@Const @ByRef PointVector corners);

// Returns random 'count' element subset of the {0,1,...,size-1} set
@Namespace("cv::detail") public static native void selectRandomSubset(int count, int size, @StdVector IntPointer subset);
@Namespace("cv::detail") public static native void selectRandomSubset(int count, int size, @StdVector IntBuffer subset);
@Namespace("cv::detail") public static native void selectRandomSubset(int count, int size, @StdVector int[] subset);

@Namespace("cv::detail") public static native @ByRef IntPointer stitchingLogLevel();

/** \} */

 // namespace detail
 // namespace cv

// #include "util_inl.hpp"

// #endif // OPENCV_STITCHING_UTIL_HPP


// Parsed from <opencv2/stitching/detail/camera.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_CAMERA_HPP
// #define OPENCV_STITCHING_CAMERA_HPP

// #include "opencv2/core.hpp"
// Targeting ../opencv_stitching/CameraParams.java



/** \} */

 // namespace detail
 // namespace cv

// #endif // #ifndef OPENCV_STITCHING_CAMERA_HPP


// Parsed from <opencv2/stitching/detail/motion_estimators.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_MOTION_ESTIMATORS_HPP
// #define OPENCV_STITCHING_MOTION_ESTIMATORS_HPP

// #include "opencv2/core.hpp"
// #include "matchers.hpp"
// #include "util.hpp"
// #include "camera.hpp"
// Targeting ../opencv_stitching/Estimator.java


// Targeting ../opencv_stitching/HomographyBasedEstimator.java


// Targeting ../opencv_stitching/AffineBasedEstimator.java


// Targeting ../opencv_stitching/BundleAdjusterBase.java


// Targeting ../opencv_stitching/NoBundleAdjuster.java


// Targeting ../opencv_stitching/BundleAdjusterReproj.java


// Targeting ../opencv_stitching/BundleAdjusterRay.java


// Targeting ../opencv_stitching/BundleAdjusterAffine.java


// Targeting ../opencv_stitching/BundleAdjusterAffinePartial.java




/** enum cv::detail::WaveCorrectKind */
public static final int
    WAVE_CORRECT_HORIZ = 0,
    WAVE_CORRECT_VERT = 1;

/** \brief Tries to make panorama more horizontal (or vertical).
<p>
@param rmats Camera rotation matrices.
@param kind Correction kind, see detail::WaveCorrectKind.
 */
@Namespace("cv::detail") public static native void waveCorrect(@ByRef MatVector rmats, @Cast("cv::detail::WaveCorrectKind") int kind);


//////////////////////////////////////////////////////////////////////////////
// Auxiliary functions

// Returns matches graph representation in DOT language
@Namespace("cv::detail") public static native @Str BytePointer matchesGraphAsString(@ByRef StringVector pathes, @StdVector MatchesInfo pairwise_matches,
                                            float conf_threshold);

@Namespace("cv::detail") public static native @StdVector IntPointer leaveBiggestComponent(
        @StdVector ImageFeatures features,
        @StdVector MatchesInfo pairwise_matches,
        float conf_threshold);

@Namespace("cv::detail") public static native void findMaxSpanningTree(
        int num_images, @StdVector MatchesInfo pairwise_matches,
        @ByRef Graph span_tree, @StdVector IntPointer centers);
@Namespace("cv::detail") public static native void findMaxSpanningTree(
        int num_images, @StdVector MatchesInfo pairwise_matches,
        @ByRef Graph span_tree, @StdVector IntBuffer centers);
@Namespace("cv::detail") public static native void findMaxSpanningTree(
        int num_images, @StdVector MatchesInfo pairwise_matches,
        @ByRef Graph span_tree, @StdVector int[] centers);

/** \} stitching_rotation */

 // namespace detail
 // namespace cv

// #endif // OPENCV_STITCHING_MOTION_ESTIMATORS_HPP


// Parsed from <opencv2/stitching/detail/exposure_compensate.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_EXPOSURE_COMPENSATE_HPP
// #define OPENCV_STITCHING_EXPOSURE_COMPENSATE_HPP

// #if defined(NO)
// #  warning Detected Apple 'NO' macro definition, it can cause build conflicts. Please, include this header before any Apple headers.
// #endif

// #include "opencv2/core.hpp"
// Targeting ../opencv_stitching/ExposureCompensator.java


// Targeting ../opencv_stitching/NoExposureCompensator.java


// Targeting ../opencv_stitching/GainCompensator.java


// Targeting ../opencv_stitching/ChannelsCompensator.java


// Targeting ../opencv_stitching/BlocksCompensator.java


// Targeting ../opencv_stitching/BlocksGainCompensator.java


// Targeting ../opencv_stitching/BlocksChannelsCompensator.java


/** \} */

 // namespace detail
 // namespace cv

// #endif // OPENCV_STITCHING_EXPOSURE_COMPENSATE_HPP


// Parsed from <opencv2/stitching/detail/seam_finders.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_SEAM_FINDERS_HPP
// #define OPENCV_STITCHING_SEAM_FINDERS_HPP

// #include <set>
// #include "opencv2/core.hpp"
// #include "opencv2/opencv_modules.hpp"
// Targeting ../opencv_stitching/SeamFinder.java


// Targeting ../opencv_stitching/NoSeamFinder.java


// Targeting ../opencv_stitching/PairwiseSeamFinder.java


// Targeting ../opencv_stitching/VoronoiSeamFinder.java


// Targeting ../opencv_stitching/DpSeamFinder.java


// Targeting ../opencv_stitching/GraphCutSeamFinderBase.java


// Targeting ../opencv_stitching/GraphCutSeamFinder.java




// #ifdef HAVE_OPENCV_CUDALEGACY
// #endif

/** \} */

 // namespace detail
 // namespace cv

// #endif // OPENCV_STITCHING_SEAM_FINDERS_HPP


// Parsed from <opencv2/stitching/detail/blenders.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_BLENDERS_HPP
// #define OPENCV_STITCHING_BLENDERS_HPP

// #if defined(NO)
// #  warning Detected Apple 'NO' macro definition, it can cause build conflicts. Please, include this header before any Apple headers.
// #endif

// #include "opencv2/core.hpp"
// #include "opencv2/core/cuda.hpp"
// Targeting ../opencv_stitching/Blender.java


// Targeting ../opencv_stitching/FeatherBlender.java




// Targeting ../opencv_stitching/MultiBandBlender.java




//////////////////////////////////////////////////////////////////////////////
// Auxiliary functions

@Namespace("cv::detail") public static native void normalizeUsingWeightMap(@ByVal Mat weight, @ByVal Mat src);
@Namespace("cv::detail") public static native void normalizeUsingWeightMap(@ByVal UMat weight, @ByVal UMat src);
@Namespace("cv::detail") public static native void normalizeUsingWeightMap(@ByVal GpuMat weight, @ByVal GpuMat src);

@Namespace("cv::detail") public static native void createWeightMap(@ByVal Mat mask, float sharpness, @ByVal Mat weight);
@Namespace("cv::detail") public static native void createWeightMap(@ByVal UMat mask, float sharpness, @ByVal UMat weight);
@Namespace("cv::detail") public static native void createWeightMap(@ByVal GpuMat mask, float sharpness, @ByVal GpuMat weight);

@Namespace("cv::detail") public static native void createLaplacePyr(@ByVal Mat img, int num_levels, @ByRef UMatVector pyr);
@Namespace("cv::detail") public static native void createLaplacePyr(@ByVal UMat img, int num_levels, @ByRef UMatVector pyr);
@Namespace("cv::detail") public static native void createLaplacePyr(@ByVal GpuMat img, int num_levels, @ByRef UMatVector pyr);
@Namespace("cv::detail") public static native void createLaplacePyrGpu(@ByVal Mat img, int num_levels, @ByRef UMatVector pyr);
@Namespace("cv::detail") public static native void createLaplacePyrGpu(@ByVal UMat img, int num_levels, @ByRef UMatVector pyr);
@Namespace("cv::detail") public static native void createLaplacePyrGpu(@ByVal GpuMat img, int num_levels, @ByRef UMatVector pyr);

// Restores source image
@Namespace("cv::detail") public static native void restoreImageFromLaplacePyr(@ByRef UMatVector pyr);
@Namespace("cv::detail") public static native void restoreImageFromLaplacePyrGpu(@ByRef UMatVector pyr);

/** \} */

 // namespace detail
 // namespace cv

// #endif // OPENCV_STITCHING_BLENDERS_HPP


// Parsed from <opencv2/stitching/detail/autocalib.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_AUTOCALIB_HPP
// #define OPENCV_STITCHING_AUTOCALIB_HPP

// #include "opencv2/core.hpp"
// #include "matchers.hpp"

/** \addtogroup stitching_autocalib
 *  \{
<p>
/** \brief Tries to estimate focal lengths from the given homography under the assumption that the camera
undergoes rotations around its centre only.
<p>
@param H Homography.
@param f0 Estimated focal length along X axis.
@param f1 Estimated focal length along Y axis.
@param f0_ok True, if f0 was estimated successfully, false otherwise.
@param f1_ok True, if f1 was estimated successfully, false otherwise.
<p>
See "Construction of Panoramic Image Mosaics with Global and Local Alignment"
by Heung-Yeung Shum and Richard Szeliski.
 */
@Namespace("cv::detail") public static native void focalsFromHomography(@Const @ByRef Mat H, @ByRef DoublePointer f0, @ByRef DoublePointer f1, @Cast("bool*") @ByRef BoolPointer f0_ok, @Cast("bool*") @ByRef BoolPointer f1_ok);
@Namespace("cv::detail") public static native void focalsFromHomography(@Const @ByRef Mat H, @ByRef DoubleBuffer f0, @ByRef DoubleBuffer f1, @Cast("bool*") @ByRef boolean[] f0_ok, @Cast("bool*") @ByRef boolean[] f1_ok);
@Namespace("cv::detail") public static native void focalsFromHomography(@Const @ByRef Mat H, @ByRef double[] f0, @ByRef double[] f1, @Cast("bool*") @ByRef BoolPointer f0_ok, @Cast("bool*") @ByRef BoolPointer f1_ok);
@Namespace("cv::detail") public static native void focalsFromHomography(@Const @ByRef Mat H, @ByRef DoublePointer f0, @ByRef DoublePointer f1, @Cast("bool*") @ByRef boolean[] f0_ok, @Cast("bool*") @ByRef boolean[] f1_ok);
@Namespace("cv::detail") public static native void focalsFromHomography(@Const @ByRef Mat H, @ByRef DoubleBuffer f0, @ByRef DoubleBuffer f1, @Cast("bool*") @ByRef BoolPointer f0_ok, @Cast("bool*") @ByRef BoolPointer f1_ok);
@Namespace("cv::detail") public static native void focalsFromHomography(@Const @ByRef Mat H, @ByRef double[] f0, @ByRef double[] f1, @Cast("bool*") @ByRef boolean[] f0_ok, @Cast("bool*") @ByRef boolean[] f1_ok);

/** \brief Estimates focal lengths for each given camera.
<p>
@param features Features of images.
@param pairwise_matches Matches between all image pairs.
@param focals Estimated focal lengths for each camera.
 */
@Namespace("cv::detail") public static native void estimateFocal(@StdVector ImageFeatures features,
                              @StdVector MatchesInfo pairwise_matches,
                              @StdVector DoublePointer focals);
@Namespace("cv::detail") public static native void estimateFocal(@StdVector ImageFeatures features,
                              @StdVector MatchesInfo pairwise_matches,
                              @StdVector DoubleBuffer focals);
@Namespace("cv::detail") public static native void estimateFocal(@StdVector ImageFeatures features,
                              @StdVector MatchesInfo pairwise_matches,
                              @StdVector double[] focals);

@Namespace("cv::detail") public static native @Cast("bool") boolean calibrateRotatingCamera(@Const @ByRef MatVector Hs,@ByRef Mat K);

/** \} stitching_autocalib */

 // namespace detail
 // namespace cv

// #endif // OPENCV_STITCHING_AUTOCALIB_HPP


// Parsed from <opencv2/stitching/detail/timelapsers.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/


// #ifndef OPENCV_STITCHING_TIMELAPSERS_HPP
// #define OPENCV_STITCHING_TIMELAPSERS_HPP

// #include "opencv2/core.hpp"
// Targeting ../opencv_stitching/Timelapser.java


// Targeting ../opencv_stitching/TimelapserCrop.java



/** \} */

 // namespace detail
 // namespace cv

// #endif // OPENCV_STITCHING_TIMELAPSERS_HPP


// Parsed from <opencv2/stitching/warpers.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_WARPER_CREATORS_HPP
// #define OPENCV_STITCHING_WARPER_CREATORS_HPP

// #include "opencv2/stitching/detail/warpers.hpp"
// #include <string>
// Targeting ../opencv_stitching/PyRotationWarper.java


// Targeting ../opencv_stitching/WarperCreator.java


// Targeting ../opencv_stitching/PlaneWarper.java



/** \brief Affine warper factory class.
  @see detail::AffineWarper
 */
// Targeting ../opencv_stitching/CylindricalWarper.java


// Targeting ../opencv_stitching/SphericalWarper.java


// Targeting ../opencv_stitching/FisheyeWarper.java


// Targeting ../opencv_stitching/StereographicWarper.java


// Targeting ../opencv_stitching/CompressedRectilinearWarper.java


// Targeting ../opencv_stitching/CompressedRectilinearPortraitWarper.java


// Targeting ../opencv_stitching/PaniniWarper.java


// Targeting ../opencv_stitching/PaniniPortraitWarper.java


// Targeting ../opencv_stitching/MercatorWarper.java


// Targeting ../opencv_stitching/TransverseMercatorWarper.java





// #ifdef HAVE_OPENCV_CUDAWARPING
// #endif

/** \} stitching_warp */

 // namespace cv

// #endif // OPENCV_STITCHING_WARPER_CREATORS_HPP


// Parsed from <opencv2/stitching.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_STITCHING_STITCHER_HPP
// #define OPENCV_STITCHING_STITCHER_HPP

// #include "opencv2/core.hpp"
// #include "opencv2/features2d.hpp"
// #include "opencv2/stitching/warpers.hpp"
// #include "opencv2/stitching/detail/matchers.hpp"
// #include "opencv2/stitching/detail/motion_estimators.hpp"
// #include "opencv2/stitching/detail/exposure_compensate.hpp"
// #include "opencv2/stitching/detail/seam_finders.hpp"
// #include "opencv2/stitching/detail/blenders.hpp"
// #include "opencv2/stitching/detail/camera.hpp"


// #if defined(Status)
// #  warning Detected X11 'Status' macro definition, it can cause build conflicts. Please, include this header before any X11 headers.
// #endif


/**
\defgroup stitching Images stitching
<p>
This figure illustrates the stitching module pipeline implemented in the Stitcher class. Using that
class it's possible to configure/remove some steps, i.e. adjust the stitching pipeline according to
the particular needs. All building blocks from the pipeline are available in the detail namespace,
one can combine and use them separately.
<p>
The implemented stitching pipeline is very similar to the one proposed in \cite BL07 .
<p>
![stitching pipeline](StitchingPipeline.jpg)
<p>
Camera models
-------------
<p>
There are currently 2 camera models implemented in stitching pipeline.
<p>
- _Homography model_ expecting perspective transformations between images
  implemented in \ref cv::detail::BestOf2NearestMatcher cv::detail::HomographyBasedEstimator
  cv::detail::BundleAdjusterReproj cv::detail::BundleAdjusterRay
- _Affine model_ expecting affine transformation with 6 DOF or 4 DOF implemented in
  \ref cv::detail::AffineBestOf2NearestMatcher cv::detail::AffineBasedEstimator
  cv::detail::BundleAdjusterAffine cv::detail::BundleAdjusterAffinePartial cv::AffineWarper
<p>
Homography model is useful for creating photo panoramas captured by camera,
while affine-based model can be used to stitch scans and object captured by
specialized devices. Use \ref cv::Stitcher::create to get preconfigured pipeline for one
of those models.
<p>
\note
Certain detailed settings of \ref cv::Stitcher might not make sense. Especially
you should not mix classes implementing affine model and classes implementing
Homography model, as they work with different transformations.
<p>
\{
    \defgroup stitching_match Features Finding and Images Matching
    \defgroup stitching_rotation Rotation Estimation
    \defgroup stitching_autocalib Autocalibration
    \defgroup stitching_warp Images Warping
    \defgroup stitching_seam Seam Estimation
    \defgroup stitching_exposure Exposure Compensation
    \defgroup stitching_blend Image Blenders
\}
  */
// Targeting ../opencv_stitching/Stitcher.java



/**
 * @deprecated use Stitcher::create
 */
@Namespace("cv") public static native @Ptr Stitcher createStitcher(@Cast("bool") boolean try_use_gpu/*=false*/);
@Namespace("cv") public static native @Ptr Stitcher createStitcher();

/**
 * @deprecated use Stitcher::create
 */
@Namespace("cv") public static native @Ptr Stitcher createStitcherScans(@Cast("bool") boolean try_use_gpu/*=false*/);
@Namespace("cv") public static native @Ptr Stitcher createStitcherScans();

/** \} stitching */

 // namespace cv

// #endif // OPENCV_STITCHING_STITCHER_HPP


}
