// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.nvml;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.cuda.cudart.*;
import static org.bytedeco.cuda.global.cudart.*;

import static org.bytedeco.cuda.global.nvml.*;

/** \} */

/***************************************************************************************************/
/** \defgroup nvmlExcludedGpuQueries Excluded GPU Queries
 * This chapter describes NVML operations that are associated with excluded GPUs.
 *  \{
 */
/***************************************************************************************************/

/**
 * Excluded GPU device information
 **/
@Properties(inherit = org.bytedeco.cuda.presets.nvml.class)
public class nvmlExcludedDeviceInfo_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public nvmlExcludedDeviceInfo_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public nvmlExcludedDeviceInfo_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public nvmlExcludedDeviceInfo_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public nvmlExcludedDeviceInfo_t position(long position) {
        return (nvmlExcludedDeviceInfo_t)super.position(position);
    }
    @Override public nvmlExcludedDeviceInfo_t getPointer(long i) {
        return new nvmlExcludedDeviceInfo_t((Pointer)this).offsetAddress(i);
    }

    /** The PCI information for the excluded GPU */
    public native @ByRef nvmlPciInfo_t pciInfo(); public native nvmlExcludedDeviceInfo_t pciInfo(nvmlPciInfo_t setter);
    /** The ASCII string UUID for the excluded GPU */
    public native @Cast("char") byte uuid(int i); public native nvmlExcludedDeviceInfo_t uuid(int i, byte setter);
    @MemberGetter public native @Cast("char*") BytePointer uuid();
}
