// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Specifies a location for an allocation.
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUmemLocation extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUmemLocation() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUmemLocation(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUmemLocation(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUmemLocation position(long position) {
        return (CUmemLocation)super.position(position);
    }
    @Override public CUmemLocation getPointer(long i) {
        return new CUmemLocation((Pointer)this).position(position + i);
    }

    /** Specifies the location type, which modifies the meaning of id. */
    public native @Cast("CUmemLocationType") int type(); public native CUmemLocation type(int setter);
    /** identifier for a given this location's ::CUmemLocationType. */
    public native int id(); public native CUmemLocation id(int setter);
}
