// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.cuda.cudart;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.cuda.global.cudart.*;


/**
 * Specifies the CUDA array or CUDA mipmapped array memory mapping information
 */
@Properties(inherit = org.bytedeco.cuda.presets.cudart.class)
public class CUarrayMapInfo extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CUarrayMapInfo() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CUarrayMapInfo(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CUarrayMapInfo(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CUarrayMapInfo position(long position) {
        return (CUarrayMapInfo)super.position(position);
    }
    @Override public CUarrayMapInfo getPointer(long i) {
        return new CUarrayMapInfo((Pointer)this).position(position + i);
    }
    
    /** Resource type */
    public native @Cast("CUresourcetype") int resourceType(); public native CUarrayMapInfo resourceType(int setter);

        @Name("resource.mipmap") public native CUmipmappedArray_st resource_mipmap(); public native CUarrayMapInfo resource_mipmap(CUmipmappedArray_st setter);
        @Name("resource.array") public native CUarray_st resource_array(); public native CUarrayMapInfo resource_array(CUarray_st setter);

    /** Sparse subresource type */
    public native @Cast("CUarraySparseSubresourceType") int subresourceType(); public native CUarrayMapInfo subresourceType(int setter);

    
    /** Memory operation type */
    public native @Cast("CUmemOperationType") int memOperationType(); public native CUarrayMapInfo memOperationType(int setter);
    /** Memory handle type */
    public native @Cast("CUmemHandleType") int memHandleType(); public native CUarrayMapInfo memHandleType(int setter);

        @Name("memHandle.memHandle") public native @Cast("CUmemGenericAllocationHandle") long memHandle_memHandle(); public native CUarrayMapInfo memHandle_memHandle(long setter);
    
    /** Offset within the memory */
    public native @Cast("unsigned long long") long offset(); public native CUarrayMapInfo offset(long setter);
    /** Device ordinal bit mask */
    public native @Cast("unsigned int") int deviceBitMask(); public native CUarrayMapInfo deviceBitMask(int setter);
    /** flags for future use, must be zero now. */
    public native @Cast("unsigned int") int flags(); public native CUarrayMapInfo flags(int setter);
    /** Reserved for future use, must be zero now. */
    public native @Cast("unsigned int") int reserved(int i); public native CUarrayMapInfo reserved(int i, int setter);
    @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();
}
