/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.lang.reflect.Field;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.version.Jetty9WebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9WebSocketHandler
implements WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(Jetty9WebSocketHandler.class);
    private AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private final WebSocketProcessor webSocketProcessor;
    private WebSocket webSocket;
    private static final boolean jetty93Up;

    public Jetty9WebSocketHandler(HttpServletRequest request, AtmosphereFramework framework, WebSocketProcessor webSocketProcessor) {
        this.framework = framework;
        this.request = this.cloneRequest(request);
        this.webSocketProcessor = webSocketProcessor;
    }

    private AtmosphereRequest cloneRequest(HttpServletRequest request) {
        try {
            AtmosphereRequest r = AtmosphereRequestImpl.wrap(request);
            return AtmosphereRequestImpl.cloneRequest(r, false, false, false, this.framework.getAtmosphereConfig().getInitParameter("org.atmosphere.cpr.sessionCreate", true));
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            throw new RuntimeException("Invalid WebSocket Request");
        }
    }

    public void onWebSocketBinary(byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(int closeCode, String s) {
        logger.trace("onClose {}:{}", (Object)closeCode, (Object)s);
        try {
            this.webSocketProcessor.close(this.webSocket, closeCode);
        }
        finally {
            this.request.destroy();
        }
    }

    public void onWebSocketConnect(Session session) {
        logger.trace("WebSocket.onOpen.");
        this.webSocket = new Jetty9WebSocket(session, this.framework.getAtmosphereConfig());
        if (jetty93Up) {
            HttpServletRequest r = this.originalRequest(session);
            this.request = r != null ? AtmosphereRequestImpl.cloneRequest(r, true, false, false, this.framework.getAtmosphereConfig().getInitParameter("org.atmosphere.cpr.sessionCreate", true)) : AtmosphereRequestImpl.cloneRequest(r, true, true, false, this.framework.getAtmosphereConfig().getInitParameter("org.atmosphere.cpr.sessionCreate", true));
        }
        try {
            this.webSocketProcessor.open(this.webSocket, this.request, AtmosphereResponseImpl.newInstance(this.framework.getAtmosphereConfig(), this.request, this.webSocket));
        }
        catch (Exception e) {
            logger.warn("Failed to connect to WebSocket", (Throwable)e);
        }
    }

    public void onWebSocketError(Throwable e) {
        logger.error("{}", e);
        this.onWebSocketClose(1006, "Unexpected error");
    }

    public void onWebSocketText(String s) {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(this.webSocket, s);
    }

    private HttpServletRequest originalRequest(Session session) {
        try {
            Field[] fields;
            ServletUpgradeRequest request = (ServletUpgradeRequest)session.getUpgradeRequest();
            for (Field f : fields = ServletUpgradeRequest.class.getDeclaredFields()) {
                f.setAccessible(true);
                Object o = f.get(request);
                if (!(o instanceof HttpServletRequest)) continue;
                return (HttpServletRequest)HttpServletRequest.class.cast(o);
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassNotFoundException ex = null;
        try {
            Class.forName("org.eclipse.jetty.websocket.api.WebSocketFrameListener");
            jetty93Up = ex == null;
        }
        catch (ClassNotFoundException e) {
            try {
                ex = e;
                jetty93Up = ex == null;
            }
            catch (Throwable throwable) {
                jetty93Up = ex == null;
                throw throwable;
            }
        }
    }
}

