/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResponse
extends HttpServletResponseWrapper {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResponse.class);
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers;
    private AsyncIOWriter asyncIOWriter;
    private int status = 200;
    private String statusMessage = "OK";
    private String charSet = "UTF-8";
    private long contentLength = -1L;
    private String contentType = "text/html";
    private boolean isCommited = false;
    private Locale locale;
    private boolean headerHandled = false;
    private AtmosphereRequest atmosphereRequest;
    private static final DummyHttpServletResponse dsr = new DummyHttpServletResponse();
    private final AtomicBoolean writeStatusAndHeader = new AtomicBoolean(false);
    private final boolean delegateToNativeResponse;
    private boolean destroyable;
    private HttpServletResponse response;
    private boolean forceAsyncIOWriter = false;

    public AtmosphereResponse(AsyncIOWriter asyncIOWriter, AtmosphereRequest atmosphereRequest, boolean destroyable) {
        super((HttpServletResponse)dsr);
        this.response = dsr;
        this.asyncIOWriter = asyncIOWriter;
        this.atmosphereRequest = atmosphereRequest;
        this.writeStatusAndHeader.set(false);
        this.headers = new HashMap<String, String>();
        this.delegateToNativeResponse = asyncIOWriter == null;
        this.destroyable = destroyable;
    }

    public AtmosphereResponse(HttpServletResponse r, AsyncIOWriter asyncIOWriter, AtmosphereRequest atmosphereRequest, boolean destroyable) {
        super(r);
        this.response = r;
        this.asyncIOWriter = asyncIOWriter;
        this.atmosphereRequest = atmosphereRequest;
        this.writeStatusAndHeader.set(false);
        this.headers = new HashMap<String, String>();
        this.delegateToNativeResponse = asyncIOWriter == null;
        this.destroyable = destroyable;
    }

    private AtmosphereResponse(Builder b) {
        super(b.atmosphereResponse);
        this.response = b.atmosphereResponse;
        this.asyncIOWriter = b.asyncIOWriter;
        this.atmosphereRequest = b.atmosphereRequest;
        this.status = b.status;
        this.statusMessage = b.statusMessage;
        this.writeStatusAndHeader.set(b.writeStatusAndHeader.get());
        this.headers = b.headers;
        this.delegateToNativeResponse = this.asyncIOWriter == null;
        this.destroyable = b.destroyable;
    }

    private HttpServletResponse _r() {
        return (HttpServletResponse)HttpServletResponse.class.cast(this.response);
    }

    public void destroy() {
        if (!this.destroyable) {
            return;
        }
        this.cookies.clear();
        this.headers.clear();
        this.atmosphereRequest = null;
        this.asyncIOWriter = null;
    }

    public void addCookie(Cookie cookie) {
        if (this.delegateToNativeResponse) {
            this._r().addCookie(cookie);
        } else {
            this.cookies.add(cookie);
        }
    }

    public boolean containsHeader(String name) {
        return !this.delegateToNativeResponse ? this.headers.get(name) != null : this._r().containsHeader(name);
    }

    public String encodeURL(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (!this.delegateToNativeResponse || this.forceAsyncIOWriter) {
            this.setStatus(sc, msg);
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.writeError(this, sc, msg);
            this.forceAsyncIOWriter = b;
        } else if (!this._r().isCommitted()) {
            this._r().sendError(sc, msg);
        } else {
            logger.warn("Committed error code {} {}", (Object)sc, (Object)msg);
        }
    }

    public void sendError(int sc) throws IOException {
        if (!this.delegateToNativeResponse || this.forceAsyncIOWriter) {
            this.setStatus(sc);
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.writeError(this, sc, "");
            this.forceAsyncIOWriter = b;
        } else if (!this._r().isCommitted()) {
            this._r().sendError(sc);
        } else {
            logger.warn("Committed error code {}", (Object)sc);
        }
    }

    public void sendRedirect(String location) throws IOException {
        if (!this.delegateToNativeResponse || this.forceAsyncIOWriter) {
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.redirect(this, location);
            this.forceAsyncIOWriter = b;
        } else {
            this._r().sendRedirect(location);
        }
    }

    public void setDateHeader(String name, long date) {
        if (!this.delegateToNativeResponse) {
            this.headers.put(name, String.valueOf(date));
        } else {
            this._r().setDateHeader(name, date);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!this.delegateToNativeResponse) {
            this.headers.put(name, String.valueOf(date));
        } else {
            this._r().setDateHeader(name, date);
        }
    }

    public void setHeader(String name, String value) {
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
        if (this.delegateToNativeResponse) {
            this._r().addHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void setStatus(int status) {
        if (!this.delegateToNativeResponse) {
            this.status = status;
        } else {
            this._r().setStatus(status);
        }
    }

    public void setStatus(int status, String statusMessage) {
        if (!this.delegateToNativeResponse) {
            this.statusMessage = statusMessage;
            this.status = status;
        } else {
            this._r().setStatus(status, statusMessage);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Map<String, String> headers() {
        if (!this.headerHandled) {
            for (Cookie c : this.cookies) {
                this.headers.put("Set-Cookie", c.toString());
            }
            this.headerHandled = false;
        }
        return this.headers;
    }

    public String getHeader(String name) {
        if (name.equalsIgnoreCase("content-type")) {
            String s = this.headers.get("Content-Type");
            return s == null ? this.contentType : s;
        }
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> s = new ArrayList<String>();
        String h = name.equalsIgnoreCase("content-type") ? this.headers.get("Content-Type") : this.headers.get(name);
        s.add(h);
        return Collections.unmodifiableList(s);
    }

    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public void setCharacterEncoding(String charSet) {
        if (!this.delegateToNativeResponse) {
            this.charSet = charSet;
        } else {
            this.response.setCharacterEncoding(charSet);
        }
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public String getCharacterEncoding() {
        if (!this.delegateToNativeResponse) {
            return this.charSet;
        }
        return this._r().getCharacterEncoding();
    }

    public boolean isDestroyable() {
        return this.destroyable;
    }

    public AtmosphereResponse destroyable(boolean destroyable) {
        this.destroyable = destroyable;
        return this;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (!this.delegateToNativeResponse || this.forceAsyncIOWriter) {
            return new ServletOutputStream(){

                public void write(int i) throws IOException {
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    AtmosphereResponse.this.forceAsyncIOWriter = false;
                    AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new byte[]{(byte)i});
                    AtmosphereResponse.this.forceAsyncIOWriter = b;
                }

                public void write(byte[] bytes) throws IOException {
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    AtmosphereResponse.this.forceAsyncIOWriter = false;
                    AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, bytes);
                    AtmosphereResponse.this.forceAsyncIOWriter = b;
                }

                public void write(byte[] bytes, int start, int offset) throws IOException {
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    AtmosphereResponse.this.forceAsyncIOWriter = false;
                    AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, bytes, start, offset);
                    AtmosphereResponse.this.forceAsyncIOWriter = b;
                }

                public void flush() throws IOException {
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    AtmosphereResponse.this.forceAsyncIOWriter = false;
                    AtmosphereResponse.this.asyncIOWriter.flush(AtmosphereResponse.this);
                    AtmosphereResponse.this.forceAsyncIOWriter = b;
                }

                public void close() throws IOException {
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    AtmosphereResponse.this.forceAsyncIOWriter = false;
                    AtmosphereResponse.this.asyncIOWriter.close(AtmosphereResponse.this);
                    AtmosphereResponse.this.forceAsyncIOWriter = b;
                }
            };
        }
        return this._r().getOutputStream();
    }

    private void writeStatusAndHeaders() throws IOException {
        if (this.writeStatusAndHeader.getAndSet(false) && !this.forceAsyncIOWriter) {
            this.asyncIOWriter.write(this, this.constructStatusAndHeaders());
        }
    }

    private String constructStatusAndHeaders() {
        StringBuffer b = new StringBuffer("HTTP/1.1").append(" ").append(this.status).append(" ").append(this.statusMessage).append("\n");
        b.append("Content-Type").append(":").append(this.headers.get("Content-Type") == null ? this.contentType : this.headers.get("Content-Type")).append("\n");
        if (this.contentLength != -1L) {
            b.append("Content-Length").append(":").append(this.contentLength).append("\n");
        }
        for (String s : this.headers().keySet()) {
            if (s.equalsIgnoreCase("Content-Type")) continue;
            b.append(s).append(":").append(this.headers.get(s)).append("\n");
        }
        b.deleteCharAt(b.length() - 1);
        b.append("\r\n\r\n");
        return b.toString();
    }

    public PrintWriter getWriter() throws IOException {
        if (!this.delegateToNativeResponse || this.forceAsyncIOWriter) {
            return new PrintWriter((OutputStream)this.getOutputStream()){

                @Override
                public void write(char[] chars, int offset, int lenght) {
                    try {
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new String(chars, offset, lenght));
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void write(char[] chars) {
                    try {
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new String(chars));
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void write(String s, int offset, int lenght) {
                    try {
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new String(s.substring(offset, lenght)));
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void write(String s) {
                    try {
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new String(s));
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        return this._r().getWriter();
    }

    public void setContentLength(int len) {
        if (!this.delegateToNativeResponse) {
            this.contentLength = len;
        } else {
            this._r().setContentLength(len);
        }
    }

    public void setContentType(String contentType) {
        if (!this.delegateToNativeResponse) {
            this.contentType = contentType;
        } else {
            this._r().setContentType(contentType);
        }
    }

    public String getContentType() {
        if (!this.delegateToNativeResponse) {
            return this.contentType;
        }
        return this._r().getContentType();
    }

    public boolean isCommitted() {
        if (!this.delegateToNativeResponse) {
            return this.isCommited;
        }
        return this._r().isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void resetBuffer() {
        this.response.resetBuffer();
    }

    public void setBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    public void setLocale(Locale locale) {
        if (!this.delegateToNativeResponse) {
            this.locale = locale;
        } else {
            this._r().setLocale(locale);
        }
    }

    public Locale getLocale() {
        if (!this.delegateToNativeResponse) {
            return this.locale;
        }
        return this._r().getLocale();
    }

    public AsyncIOWriter getAsyncIOWriter() {
        return this.asyncIOWriter;
    }

    public AtmosphereResponse asyncIOWriter(AsyncIOWriter asyncIOWriter) {
        this.asyncIOWriter = asyncIOWriter;
        this.forceAsyncIOWriter = true;
        return this;
    }

    public AtmosphereRequest request() {
        return this.atmosphereRequest;
    }

    public AtmosphereResponse request(AtmosphereRequest atmosphereRequest) {
        this.atmosphereRequest = atmosphereRequest;
        return this;
    }

    public void close() throws IOException {
        if (this.asyncIOWriter != null) {
            this.asyncIOWriter.close(this);
        }
    }

    public void closeStreamOrWriter() {
        try {
            boolean isUsingStream = (Boolean)this.request().getAttribute("org.atmosphere.useStream");
            if (isUsingStream) {
                try {
                    this.getOutputStream().close();
                }
                catch (IllegalStateException illegalStateException) {}
            } else {
                this.getWriter().close();
            }
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
    }

    public AtmosphereResponse write(String data) {
        boolean isUsingStream = (Boolean)this.request().getAttribute("org.atmosphere.useStream");
        try {
            if (isUsingStream) {
                try {
                    this.getOutputStream().write(data.getBytes(this.getCharacterEncoding()));
                }
                catch (IllegalStateException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.getWriter().write(data);
            }
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
        return this;
    }

    public AtmosphereResponse write(byte[] data) {
        boolean isUsingStream = (Boolean)this.request().getAttribute("org.atmosphere.useStream");
        try {
            if (isUsingStream) {
                try {
                    this.getOutputStream().write(data);
                }
                catch (IllegalStateException ex) {}
            } else {
                this.getWriter().write(new String(data, this.getCharacterEncoding()));
            }
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
        return this;
    }

    public AtmosphereResponse write(byte[] data, int offset, int length) {
        boolean isUsingStream = (Boolean)this.request().getAttribute("org.atmosphere.useStream");
        try {
            if (isUsingStream) {
                try {
                    this.getOutputStream().write(data, offset, length);
                }
                catch (IllegalStateException ex) {}
            } else {
                this.getWriter().write(new String(data, offset, length, this.getCharacterEncoding()));
            }
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
        return this;
    }

    public AtmosphereResource resource() {
        if (this.atmosphereRequest != null) {
            return (AtmosphereResource)this.atmosphereRequest.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        }
        return null;
    }

    public void setResponse(ServletResponse response) {
        super.setResponse(response);
        if (HttpServletResponse.class.isAssignableFrom(response.getClass())) {
            this.response = (HttpServletResponse)HttpServletResponse.class.cast(response);
        }
    }

    public static final AtmosphereResponse create() {
        return new Builder().build();
    }

    public static final AtmosphereResponse wrap(HttpServletResponse response) {
        return new Builder().response(response).build();
    }

    public String toString() {
        return "AtmosphereResponse{cookies=" + this.cookies + ", headers=" + this.headers + ", asyncIOWriter=" + this.asyncIOWriter + ", status=" + this.status + ", statusMessage='" + this.statusMessage + '\'' + ", charSet='" + this.charSet + '\'' + ", contentLength=" + this.contentLength + ", contentType='" + this.contentType + '\'' + ", isCommited=" + this.isCommited + ", locale=" + this.locale + ", headerHandled=" + this.headerHandled + ", atmosphereRequest=" + (Object)((Object)this.atmosphereRequest) + ", writeStatusAndHeader=" + this.writeStatusAndHeader + ", delegateToNativeResponse=" + this.delegateToNativeResponse + ", destroyable=" + this.destroyable + ", response=" + this.response + '}';
    }

    static /* synthetic */ DummyHttpServletResponse access$800() {
        return dsr;
    }

    private static final class NoOpsPrintWriter
    extends Writer {
        private NoOpsPrintWriter() {
        }

        @Override
        public void write(char[] chars, int i, int i1) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static final class NoOpsOutputStream
    extends ServletOutputStream {
        private NoOpsOutputStream() {
        }

        public void write(int i) throws IOException {
        }
    }

    private static final class DummyHttpServletResponse
    implements HttpServletResponse {
        private DummyHttpServletResponse() {
        }

        public void addCookie(Cookie cookie) {
            logger.trace("Unsupported");
        }

        public boolean containsHeader(String name) {
            logger.trace("Unsupported");
            return false;
        }

        public String encodeURL(String url) {
            logger.trace("Unsupported");
            return url;
        }

        public String encodeRedirectURL(String url) {
            logger.trace("Unsupported");
            return url;
        }

        public String encodeUrl(String url) {
            logger.trace("Unsupported");
            return url;
        }

        public String encodeRedirectUrl(String url) {
            logger.trace("Unsupported");
            return url;
        }

        public void sendError(int sc, String msg) throws IOException {
            logger.trace("Unsupported");
        }

        public void sendError(int sc) throws IOException {
            logger.trace("Unsupported");
        }

        public void sendRedirect(String location) throws IOException {
            logger.trace("Unsupported");
        }

        public void setDateHeader(String name, long date) {
            logger.trace("Unsupported");
        }

        public void addDateHeader(String name, long date) {
            logger.trace("Unsupported");
        }

        public void setHeader(String name, String value) {
            logger.trace("Unsupported");
        }

        public void addHeader(String name, String value) {
            logger.trace("Unsupported");
        }

        public void setIntHeader(String name, int value) {
            logger.trace("Unsupported");
        }

        public void addIntHeader(String name, int value) {
            logger.trace("Unsupported");
        }

        public void setStatus(int sc) {
            logger.trace("Unsupported");
        }

        public void setStatus(int sc, String sm) {
            logger.trace("Unsupported");
        }

        public int getStatus() {
            logger.trace("Unsupported");
            return 200;
        }

        public String getHeader(String name) {
            logger.trace("Unsupported");
            return null;
        }

        public Collection<String> getHeaders(String name) {
            logger.trace("Unsupported");
            return Collections.emptyList();
        }

        public Collection<String> getHeaderNames() {
            logger.trace("Unsupported");
            return Collections.emptyList();
        }

        public String getCharacterEncoding() {
            logger.trace("Unsupported");
            return "ISO-8859-1";
        }

        public String getContentType() {
            logger.trace("Unsupported");
            return "text/plain";
        }

        public ServletOutputStream getOutputStream() throws IOException {
            logger.trace("Unsupported");
            return new NoOpsOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            logger.trace("Unsupported");
            return new PrintWriter(new NoOpsPrintWriter());
        }

        public void setCharacterEncoding(String charset) {
            logger.trace("Unsupported");
        }

        public void setContentLength(int len) {
            logger.trace("Unsupported");
        }

        public void setContentType(String type) {
            logger.trace("Unsupported");
        }

        public void setBufferSize(int size) {
            logger.trace("Unsupported");
        }

        public int getBufferSize() {
            logger.trace("Unsupported");
            return -1;
        }

        public void flushBuffer() throws IOException {
            logger.trace("Unsupported");
        }

        public void resetBuffer() {
            logger.trace("Unsupported");
        }

        public boolean isCommitted() {
            logger.trace("Unsupported");
            return false;
        }

        public void reset() {
            logger.trace("Unsupported");
        }

        public void setLocale(Locale loc) {
            logger.trace("Unsupported");
        }

        public Locale getLocale() {
            logger.trace("Unsupported");
            return Locale.ENGLISH;
        }
    }

    public static final class Builder {
        private AsyncIOWriter asyncIOWriter;
        private int status = 200;
        private String statusMessage = "OK";
        private AtmosphereRequest atmosphereRequest;
        private HttpServletResponse atmosphereResponse = AtmosphereResponse.access$800();
        private AtomicBoolean writeStatusAndHeader = new AtomicBoolean(true);
        private final Map<String, String> headers = new HashMap<String, String>();
        public boolean destroyable = true;

        public Builder destroyable(boolean isRecyclable) {
            this.destroyable = isRecyclable;
            return this;
        }

        public Builder asyncIOWriter(AsyncIOWriter asyncIOWriter) {
            this.asyncIOWriter = asyncIOWriter;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder request(AtmosphereRequest atmosphereRequest) {
            this.atmosphereRequest = atmosphereRequest;
            return this;
        }

        public AtmosphereResponse build() {
            return new AtmosphereResponse(this);
        }

        public Builder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder writeHeader(boolean writeStatusAndHeader) {
            this.writeStatusAndHeader.set(writeStatusAndHeader);
            return this;
        }

        public Builder response(HttpServletResponse res) {
            this.atmosphereResponse = res;
            return this;
        }
    }
}

