/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutPart {
    private MultivaluedMap<String, String> headers = new CaseInsensitiveMultivaluedMap<String>();
    private Object body;
    private static final Logger logger = LoggerFactory.getLogger(OutPart.class);

    public void addHeader(String name, String value) {
        this.getHeaders().add((Object)name, (Object)value);
    }

    public void setContentType(String contentType) {
        this.getHeaders().putSingle((Object)"Content-Type", (Object)contentType);
    }

    public String getContentType() {
        String res = (String)this.getHeaders().getFirst((Object)"Content-Type");
        if (res == null) {
            res = "text/plain";
        }
        return res;
    }

    public void setLocationHeader(String location) {
        this.getHeaders().putSingle((Object)"location", (Object)location);
    }

    protected void writeBody(OutputStream os, Providers providers) throws IOException {
        if (this.getBody() != null) {
            MessageBodyWriter writer = providers.getMessageBodyWriter(this.getBody().getClass(), null, null, MediaType.valueOf((String)this.getContentType()));
            if (writer == null) {
                logger.warn("Could not find a writer for {} and {}. Try to find JAF DataSourceProvider", this.getBody().getClass(), (Object)this.getContentType());
                throw new WebApplicationException(500);
            }
            writer.writeTo(this.getBody(), this.getBody().getClass(), null, null, MediaType.valueOf((String)this.getContentType()), this.getHeaders(), os);
        }
    }

    public void writePart(OutputStream os, Providers providers) throws IOException {
        for (String name : this.getHeaders().keySet()) {
            List values = (List)this.getHeaders().get((Object)name);
            for (String value : values) {
                String header = name + ": " + value + "\n";
                os.write(header.getBytes());
            }
        }
        os.write("\n".getBytes());
        this.writeBody(os, providers);
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public Object getBody() {
        return this.body;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }
}

