/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.config.Field;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIFSContainerDetector
implements Detector {
    public static final MediaType OLE = MediaType.application((String)"x-tika-msoffice");
    public static final MediaType OOXML_PROTECTED = MediaType.application((String)"x-tika-ooxml-protected");
    public static final MediaType DRM_ENCRYPTED = MediaType.application((String)"x-tika-ole-drm-encrypted");
    public static final MediaType GENERAL_EMBEDDED = MediaType.application((String)"x-tika-msoffice-embedded");
    public static final MediaType OLE10_NATIVE = new MediaType(GENERAL_EMBEDDED, "format", "ole10_native");
    public static final MediaType COMP_OBJ = new MediaType(GENERAL_EMBEDDED, "format", "comp_obj");
    public static final MediaType MS_GRAPH_CHART = MediaType.application((String)"vnd.ms-graph");
    public static final MediaType MS_EQUATION = MediaType.application((String)"vnd.ms-equation");
    public static final String OCX_NAME = "\u0003OCXNAME";
    public static final MediaType XLS = MediaType.application((String)"vnd.ms-excel");
    public static final MediaType DOC = MediaType.application((String)"msword");
    public static final MediaType PPT = MediaType.application((String)"vnd.ms-powerpoint");
    public static final MediaType PUB = MediaType.application((String)"x-mspublisher");
    public static final MediaType VSD = MediaType.application((String)"vnd.visio");
    public static final MediaType WPS = MediaType.application((String)"vnd.ms-works");
    public static final MediaType XLR = MediaType.application((String)"x-tika-msworks-spreadsheet");
    public static final MediaType MSG = MediaType.application((String)"vnd.ms-outlook");
    public static final MediaType MPP = MediaType.application((String)"vnd.ms-project");
    public static final MediaType SDC = MediaType.application((String)"vnd.stardivision.calc");
    public static final MediaType SDA = MediaType.application((String)"vnd.stardivision.draw");
    public static final MediaType SDD = MediaType.application((String)"vnd.stardivision.impress");
    public static final MediaType SDW = MediaType.application((String)"vnd.stardivision.writer");
    public static final MediaType SLDWORKS = MediaType.application((String)"sldworks");
    public static final MediaType ESRI_LAYER = MediaType.application((String)"x-esri-layer");
    public static final MediaType DGN_8 = MediaType.image((String)"vnd.dgn;version=8");
    private static final long serialVersionUID = -3028021741663605293L;
    private static final String ENCRYPTED_PACKAGE = "EncryptedPackage".toUpperCase(Locale.ROOT);
    private static final String ENCRYPTED_INFO = "EncryptionInfo".toUpperCase(Locale.ROOT);
    private static final String SW_DOC_CONTENT_MGR = "SwDocContentMgr".toUpperCase(Locale.ROOT);
    private static final String SW_DOC_MGR_TEMP_STORAGE = "SwDocMgrTempStorage".toUpperCase(Locale.ROOT);
    private static final String STAR_CALC_DOCUMENT = "StarCalcDocument".toUpperCase(Locale.ROOT);
    private static final String STAR_WRITER_DOCUMENT = "StarWriterDocument".toUpperCase(Locale.ROOT);
    private static final String STAR_DRAW_DOCUMENT_3 = "StarDrawDocument3".toUpperCase(Locale.ROOT);
    private static final String WKS_SSWORK_BOOK = "WksSSWorkBook".toUpperCase(Locale.ROOT);
    private static final String DATA_SPACES = "\u0006DataSpaces".toUpperCase(Locale.ROOT);
    private static final String DRM_ENCRYPTED_DATA_SPACE = "DRMEncryptedDataSpace".toUpperCase(Locale.ROOT);
    private static final String DRM_DATA_SPACE = "\tDRMDataSpace".toUpperCase(Locale.ROOT);
    private static final String WORD_DOCUMENT = "WordDocument".toUpperCase(Locale.ROOT);
    private static final String QUILL = "Quill".toUpperCase(Locale.ROOT);
    private static final String POWERPOINT_DOCUMENT = "PowerPoint Document".toUpperCase(Locale.ROOT);
    private static final String VISIO_DOCUMENT = "VisioDocument".toUpperCase(Locale.ROOT);
    private static final String OLE10_NATIVE_STRING = "\u0001Ole10Native".toUpperCase(Locale.ROOT);
    private static final String MAT_OST = "MatOST".toUpperCase(Locale.ROOT);
    private static final String CONTENTS = "CONTENTS".toUpperCase(Locale.ROOT);
    private static final String SPELLING = "SPELLING".toUpperCase(Locale.ROOT);
    private static final String OBJ_INFO = "\u0003ObjInfo".toUpperCase(Locale.ROOT);
    private static final String COMP_OBJ_STRING = "\u0001CompObj".toUpperCase(Locale.ROOT);
    private static final String PROPS = "Props".toUpperCase(Locale.ROOT);
    private static final String PROPS_9 = "Props9".toUpperCase(Locale.ROOT);
    private static final String PROPS_12 = "Props12".toUpperCase(Locale.ROOT);
    private static final String EQUATION_NATIVE = "Equation Native".toUpperCase(Locale.ROOT);
    private static final String LAYER = "Layer".toUpperCase(Locale.ROOT);
    private static final String DGN_MF = "Dgn~Mf".toUpperCase(Locale.ROOT);
    private static final String DGN_S = "Dgn~S".toUpperCase(Locale.ROOT);
    private static final String DGN_H = "Dgn~H".toUpperCase(Locale.ROOT);
    private static final String SUBSTG_1 = "__substg1.0_".toUpperCase(Locale.ROOT);
    private static final byte[] STAR_IMPRESS = "StarImpress".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] STAR_DRAW = "StarDraw".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] WORKS_QUILL96 = "Quill96".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] MS_GRAPH_CHART_BYTES = "MSGraph.Chart".getBytes(StandardCharsets.US_ASCII);
    private static final Pattern mppDataMatch = Pattern.compile("\\s\\s\\s\\d+");
    private static final Logger LOG = LoggerFactory.getLogger(POIFSContainerDetector.class);
    @Field
    private int markLimit = -1;

    public static MediaType detect(Set<String> anyCaseNames, DirectoryEntry root) {
        if (anyCaseNames == null || anyCaseNames.isEmpty()) {
            return OLE;
        }
        Set<String> ucNames = POIFSContainerDetector.upperCase(anyCaseNames);
        MediaType mediaType = POIFSContainerDetector.checkEncrypted(ucNames, root);
        if (mediaType != null) {
            return mediaType;
        }
        for (String workbookEntryName : InternalWorkbook.WORKBOOK_DIR_ENTRY_NAMES) {
            if (!ucNames.contains(workbookEntryName)) continue;
            MediaType tmp = POIFSContainerDetector.processCompObjFormatType(root);
            if (tmp.equals((Object)MS_GRAPH_CHART)) {
                return MS_GRAPH_CHART;
            }
            return XLS;
        }
        if (ucNames.contains(SW_DOC_CONTENT_MGR) && ucNames.contains(SW_DOC_MGR_TEMP_STORAGE)) {
            return SLDWORKS;
        }
        if (ucNames.contains(STAR_CALC_DOCUMENT)) {
            return SDC;
        }
        if (ucNames.contains(STAR_WRITER_DOCUMENT)) {
            return SDW;
        }
        if (ucNames.contains(STAR_DRAW_DOCUMENT_3)) {
            if (root == null) {
                return OLE;
            }
            return POIFSContainerDetector.processCompObjFormatType(root);
        }
        if (ucNames.contains(WKS_SSWORK_BOOK)) {
            return XLR;
        }
        if (ucNames.contains("BOOK")) {
            return XLS;
        }
        if (ucNames.contains(WORD_DOCUMENT)) {
            return DOC;
        }
        if (ucNames.contains(QUILL)) {
            return PUB;
        }
        if (ucNames.contains(POWERPOINT_DOCUMENT)) {
            return PPT;
        }
        if (ucNames.contains(VISIO_DOCUMENT)) {
            return VSD;
        }
        if (ucNames.contains(OLE10_NATIVE_STRING)) {
            return OLE10_NATIVE;
        }
        if (ucNames.contains(MAT_OST)) {
            return WPS;
        }
        if (ucNames.contains(CONTENTS) && ucNames.contains(SPELLING)) {
            return WPS;
        }
        if (ucNames.contains(EQUATION_NATIVE)) {
            return MS_EQUATION;
        }
        if (ucNames.contains(OCX_NAME)) {
            return OLE;
        }
        if (ucNames.contains(CONTENTS) && ucNames.contains(OBJ_INFO)) {
            return COMP_OBJ;
        }
        if (ucNames.contains(CONTENTS) && ucNames.contains(COMP_OBJ_STRING)) {
            if (root != null) {
                MediaType type = POIFSContainerDetector.processCompObjFormatType(root);
                if (type == WPS) {
                    return WPS;
                }
                return COMP_OBJ;
            }
            return COMP_OBJ;
        }
        if (ucNames.contains(CONTENTS)) {
            return OLE;
        }
        if (ucNames.contains(COMP_OBJ_STRING) && (ucNames.contains(PROPS) || ucNames.contains(PROPS_9) || ucNames.contains(PROPS_12))) {
            for (String name : ucNames) {
                if (!mppDataMatch.matcher(name).matches()) continue;
                return MPP;
            }
        } else {
            if (ucNames.contains(LAYER)) {
                return ESRI_LAYER;
            }
            if (ucNames.contains(DGN_MF) && ucNames.contains(DGN_S) && ucNames.contains(DGN_H)) {
                return DGN_8;
            }
            for (String name : ucNames) {
                if (!name.startsWith(SUBSTG_1)) continue;
                return MSG;
            }
        }
        return OLE;
    }

    private static MediaType checkEncrypted(Set<String> ucNames, DirectoryEntry root) {
        if (ucNames.contains(DATA_SPACES) && POIFSContainerDetector.findRecursively((Entry)root, DRM_DATA_SPACE, 0, 10)) {
            return DRM_ENCRYPTED;
        }
        if (ucNames.contains(ENCRYPTED_PACKAGE)) {
            if (ucNames.contains(ENCRYPTED_INFO)) {
                return OOXML_PROTECTED;
            }
            if (ucNames.contains(DATA_SPACES) && POIFSContainerDetector.findRecursively((Entry)root, DRM_ENCRYPTED_DATA_SPACE, 0, 10)) {
                return DRM_ENCRYPTED;
            }
        }
        return null;
    }

    private static Set<String> upperCase(Set<String> names) {
        HashSet<String> uc = new HashSet<String>(names.size());
        for (String s : names) {
            uc.add(s.toUpperCase(Locale.ROOT));
        }
        return uc;
    }

    private static boolean findRecursively(Entry entry, String targetName, int depth, int maxDepth) {
        if (entry == null) {
            return false;
        }
        if (entry.getName().toUpperCase(Locale.ROOT).equals(targetName)) {
            return true;
        }
        if (depth >= maxDepth) {
            return false;
        }
        if (entry instanceof DirectoryEntry) {
            Iterator it = ((DirectoryEntry)entry).getEntries();
            while (it.hasNext()) {
                Entry child = (Entry)it.next();
                if (!POIFSContainerDetector.findRecursively(child, targetName, depth + 1, maxDepth)) continue;
                return true;
            }
        }
        return false;
    }

    private static MediaType processCompObjFormatType(DirectoryEntry root) {
        try {
            Entry entry = OfficeParser.getUCEntry(root, COMP_OBJ_STRING);
            if (entry != null && entry.isDocumentEntry()) {
                DocumentNode dn = (DocumentNode)entry;
                DocumentInputStream stream = new DocumentInputStream((DocumentEntry)dn);
                byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                if (POIFSContainerDetector.arrayContains(bytes, MS_GRAPH_CHART_BYTES)) {
                    return MS_GRAPH_CHART;
                }
                if (POIFSContainerDetector.arrayContains(bytes, STAR_DRAW)) {
                    return SDA;
                }
                if (POIFSContainerDetector.arrayContains(bytes, STAR_IMPRESS)) {
                    return SDD;
                }
                if (POIFSContainerDetector.arrayContains(bytes, WORKS_QUILL96)) {
                    return WPS;
                }
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OLE;
    }

    private static boolean arrayContains(byte[] larger, byte[] smaller) {
        int largerCounter = 0;
        int smallerCounter = 0;
        while (largerCounter < larger.length) {
            if (larger[largerCounter] == smaller[smallerCounter]) {
                ++largerCounter;
                if (++smallerCounter != smaller.length) continue;
                return true;
            }
            largerCounter = largerCounter - smallerCounter + 1;
            smallerCounter = 0;
        }
        return false;
    }

    private static Set<String> getTopLevelNames(DirectoryNode root) {
        HashSet<String> names = new HashSet<String>();
        for (Entry entry : root) {
            names.add(entry.getName());
        }
        return names;
    }

    public void setMarkLimit(int markLimit) {
        this.markLimit = markLimit;
    }

    private Set<String> getTopLevelNames(TikaInputStream stream) throws IOException {
        Path file = stream.getPath(this.markLimit);
        if (file == null) {
            LOG.warn("File length exceeds marklimit. Skipping detection on this file. If you need precise detection, consider increasing the marklimit or setting it to -1");
            return Collections.emptySet();
        }
        try {
            POIFSFileSystem fs = new POIFSFileSystem(file.toFile(), true);
            stream.setOpenContainer((Object)fs);
            return POIFSContainerDetector.getTopLevelNames(fs.getRoot());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return Collections.emptySet();
        }
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        TikaInputStream tis = TikaInputStream.cast((InputStream)input);
        if (tis != null) {
            return this.handleTikaStream(tis, metadata);
        }
        if (this.isOleHeader(input)) {
            return OLE;
        }
        return MediaType.OCTET_STREAM;
    }

    private MediaType handleTikaStream(TikaInputStream tis, Metadata metadata) throws IOException {
        Set<String> names = POIFSContainerDetector.tryOpenContainerOnTikaInputStream((InputStream)tis, metadata);
        if (names == null && !this.isOleHeader((InputStream)tis)) {
            return MediaType.OCTET_STREAM;
        }
        if (names == null) {
            names = this.getTopLevelNames(tis);
        }
        if (tis.getOpenContainer() != null && tis.getOpenContainer() instanceof POIFSFileSystem) {
            return POIFSContainerDetector.detect(names, (DirectoryEntry)((POIFSFileSystem)tis.getOpenContainer()).getRoot());
        }
        return POIFSContainerDetector.detect(names, null);
    }

    private boolean isOleHeader(InputStream input) throws IOException {
        input.mark(8);
        try {
            boolean bl = input.read() == 208 && input.read() == 207 && input.read() == 17 && input.read() == 224 && input.read() == 161 && input.read() == 177 && input.read() == 26 && input.read() == 225;
            return bl;
        }
        finally {
            input.reset();
        }
    }

    public static Set<String> tryOpenContainerOnTikaInputStream(InputStream input, Metadata metadata) {
        TikaInputStream tis = TikaInputStream.cast((InputStream)input);
        Object names = null;
        if (tis != null) {
            Object container = tis.getOpenContainer();
            if (container instanceof POIFSFileSystem) {
                return POIFSContainerDetector.getTopLevelNames(((POIFSFileSystem)container).getRoot());
            }
            if (container instanceof DirectoryNode) {
                return POIFSContainerDetector.getTopLevelNames((DirectoryNode)container);
            }
        }
        return null;
    }
}

