/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.feed;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedParser
extends AbstractParser {
    private static final long serialVersionUID = -3785361933034525186L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("rss+xml"), MediaType.application("atom+xml"))));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try {
            SyndFeed feed = new SyndFeedInput().build(new InputSource(new CloseShieldInputStream(stream)));
            String title = FeedParser.stripTags(feed.getTitleEx());
            String description = FeedParser.stripTags(feed.getDescriptionEx());
            metadata.set("title", title);
            metadata.set("description", description);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.element("h1", title);
            xhtml.element("p", description);
            xhtml.startElement("ul");
            for (Object e : feed.getEntries()) {
                SyndEntry entry = (SyndEntry)e;
                String link = entry.getLink();
                if (link == null) continue;
                xhtml.startElement("li");
                xhtml.startElement("a", "href", link);
                xhtml.characters(FeedParser.stripTags(entry.getTitleEx()));
                xhtml.endElement("a");
                SyndContent content = entry.getDescription();
                if (content != null) {
                    xhtml.newline();
                    xhtml.characters(content.getValue());
                }
                xhtml.endElement("li");
            }
            xhtml.endElement("ul");
            xhtml.endDocument();
        }
        catch (FeedException e) {
            throw new TikaException("RSS parse error", e);
        }
    }

    private static String stripTags(SyndContent c) {
        if (c == null) {
            return "";
        }
        String value = c.getValue();
        String[] parts = value.split("<[^>]*>");
        StringBuffer buf = new StringBuffer();
        for (String part : parts) {
            buf.append(part);
        }
        return buf.toString().trim();
    }
}

