/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.rtp;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;

public class RtpHintSampleEntry
extends SampleEntry
implements ContainerBox {
    public static final String TYPE1 = "rtp ";
    private int hintTrackVersion;
    private int highestCompatibleVersion;
    private long maxPacketSize;

    public RtpHintSampleEntry(byte[] type) {
        super(type);
    }

    public int getHintTrackVersion() {
        return this.hintTrackVersion;
    }

    public int getHighestCompatibleVersion() {
        return this.highestCompatibleVersion;
    }

    public long getMaxPacketSize() {
        return this.maxPacketSize;
    }

    protected long getContentSize() {
        long contentLength = 0L;
        for (Box box : this.boxes) {
            contentLength += box.getSize();
        }
        return 16L + contentLength;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.hintTrackVersion = in.readUInt16();
        this.highestCompatibleVersion = in.readUInt16();
        this.maxPacketSize = in.readUInt32();
        size -= 16L;
        while (size > 0L) {
            Box box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            size -= box.getSize();
            this.boxes.add(box);
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(new byte[6]);
        isos.writeUInt16(this.getDataReferenceIndex());
        isos.writeUInt16(this.hintTrackVersion);
        isos.writeUInt16(this.highestCompatibleVersion);
        isos.writeUInt32(this.maxPacketSize);
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RtpHintSampleEntry[");
        builder.append("hintTrackVersion=").append(this.getHintTrackVersion()).append(";");
        builder.append("highestCompatibleVersion=").append(this.getHighestCompatibleVersion()).append(";");
        builder.append("maxPacketSize=").append(this.getMaxPacketSize());
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (i > 0) {
                builder.append(";");
            }
            builder.append(((Box)this.boxes.get(i)).toString());
        }
        builder.append("]");
        return builder.toString();
    }
}

