/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleAuxiliaryInformationOffsetsBox
extends AbstractFullBox {
    public static final String TYPE = "saio";
    private long entryCount;
    private List<Long> offsets = new LinkedList<Long>();
    private long auxInfoType;
    private long auxInfoTypeParameter;

    public SampleAuxiliaryInformationOffsetsBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    protected long getContentSize() {
        return 4L + (this.getVersion() == 0 ? 4L * this.entryCount : 8L * this.entryCount) + (long)((this.getFlags() & 1) == 1 ? 8 : 0);
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        if ((this.getFlags() & 1) == 1) {
            os.writeUInt32(this.auxInfoType);
            os.writeUInt32(this.auxInfoTypeParameter);
        }
        os.writeUInt32(this.entryCount);
        for (Long offset : this.offsets) {
            if (this.getVersion() == 0) {
                os.writeUInt32(offset);
                continue;
            }
            os.writeUInt64(offset);
        }
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        if ((this.getFlags() & 1) == 1) {
            this.auxInfoType = in.readUInt32();
            this.auxInfoTypeParameter = in.readUInt32();
        }
        this.entryCount = in.readUInt32();
        this.offsets.clear();
        int i = 0;
        while ((long)i < this.entryCount) {
            if (this.getVersion() == 0) {
                this.offsets.add(in.readUInt32());
            } else {
                this.offsets.add(in.readUInt64());
            }
            ++i;
        }
    }

    public long getAuxInfoType() {
        return this.auxInfoType;
    }

    public void setAuxInfoType(long auxInfoType) {
        this.auxInfoType = auxInfoType;
    }

    public long getAuxInfoTypeParameter() {
        return this.auxInfoTypeParameter;
    }

    public void setAuxInfoTypeParameter(long auxInfoTypeParameter) {
        this.auxInfoTypeParameter = auxInfoTypeParameter;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(long entryCount) {
        this.entryCount = entryCount;
    }

    public List<Long> getOffsets() {
        return this.offsets;
    }

    public void setOffsets(List<Long> offsets) {
        this.offsets = offsets;
    }
}

