/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.upload.components;

import java.util.Locale;
import org.apache.tapestry.Binding;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.Field;
import org.apache.tapestry.FieldValidationSupport;
import org.apache.tapestry.FieldValidator;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.ValidationDecorator;
import org.apache.tapestry.ValidationException;
import org.apache.tapestry.ValidationTracker;
import org.apache.tapestry.annotations.Environmental;
import org.apache.tapestry.annotations.Mixin;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.corelib.base.AbstractField;
import org.apache.tapestry.corelib.mixins.RenderDisabled;
import org.apache.tapestry.ioc.annotations.Inject;
import org.apache.tapestry.services.FieldValidatorDefaultSource;
import org.apache.tapestry.services.FormSupport;
import org.apache.tapestry.upload.services.MultipartDecoder;
import org.apache.tapestry.upload.services.UploadedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Upload
extends AbstractField {
    public static final String MULTIPART_ENCTYPE = "multipart/form-data";
    @Parameter(required=true, principal=true)
    private UploadedFile _value;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> _validate = NOOP_VALIDATOR;
    @Environmental
    private ValidationTracker _tracker;
    @Inject
    private MultipartDecoder _decoder;
    @Environmental
    private FormSupport _formSupport;
    @Inject
    private FieldValidatorDefaultSource _fieldValidatorDefaultSource;
    @Inject
    private ComponentResources _resources;
    @Inject
    private Locale _locale;
    @Inject
    private FieldValidationSupport _fieldValidationSupport;
    @Mixin
    private RenderDisabled _renderDisabled;

    final FieldValidator defaultValidate() {
        Class type = this._resources.getBoundType("value");
        if (type == null) {
            return null;
        }
        return this._fieldValidatorDefaultSource.createDefaultValidator((Field)this, this._resources.getId(), this._resources.getContainerMessages(), this._locale, type, this._resources.getAnnotationProvider("value"));
    }

    public Upload() {
    }

    Upload(UploadedFile value, FieldValidator<Object> validate, MultipartDecoder decoder, ValidationTracker tracker, ComponentResources resources, FieldValidationSupport fieldValidationSupport) {
        this._value = value;
        if (validate != null) {
            this._validate = validate;
        }
        this._decoder = decoder;
        this._tracker = tracker;
        this._resources = resources;
        this._fieldValidationSupport = fieldValidationSupport;
    }

    protected void processSubmission(String elementName) {
        UploadedFile uploaded = this._decoder.getFileUpload(elementName);
        if (uploaded != null && (uploaded.getFileName() == null || uploaded.getFileName().length() == 0)) {
            uploaded = null;
        }
        try {
            this._fieldValidationSupport.validate((Object)uploaded, this._resources, this._validate);
        }
        catch (ValidationException ex) {
            this._tracker.recordError((Field)this, ex.getMessage());
        }
        this._value = uploaded;
    }

    protected void beginRender(MarkupWriter writer) {
        this._formSupport.setEncodingType(MULTIPART_ENCTYPE);
        writer.element("input", new Object[]{"type", "file", "name", this.getControlName(), "id", this.getClientId()});
        this._validate.render(writer);
        this._resources.renderInformalParameters(writer);
        this.decorateInsideField();
    }

    public void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public UploadedFile getValue() {
        return this._value;
    }

    Binding defaultValue() {
        return this.createDefaultParameterBinding("value");
    }

    void injectDecorator(ValidationDecorator decorator) {
        this.setDecorator(decorator);
    }

    void injectFormSupport(FormSupport formSupport) {
        this._formSupport = formSupport;
        this.setFormSupport(formSupport);
    }
}

