// Copyright 2006 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry.ioc.internal;

import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ServiceLifecycle;
import org.apache.tapestry.ioc.ServiceResources;

/**
 * The basic implementation of a service lifecycle, which simply uses the
 * {@link org.apache.tapestry.ioc.ObjectCreator} to create an instance of the service when asked.
 */
public class SingletonServiceLifecycle implements ServiceLifecycle
{
    public Object createService(ServiceResources resources, ObjectCreator creator)
    {
        return creator.createObject();
    }
}
