/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.TextUtils;
import java.io.IOException;
import java.io.Writer;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Form;
import org.apache.struts2.components.ServletUrlRenderer;
import org.apache.struts2.components.URL;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.portlet.util.PortletUrlHelper;

public class PortletUrlRenderer
implements UrlRenderer {
    private UrlRenderer servletRenderer = new ServletUrlRenderer();

    public void renderUrl(Writer writer, URL urlComponent) {
        if (PortletActionContext.getPortletContext() == null || "none".equalsIgnoreCase(urlComponent.portletUrlType)) {
            this.servletRenderer.renderUrl(writer, urlComponent);
        } else {
            String var;
            String action = null;
            if (urlComponent.action != null) {
                action = urlComponent.findString(urlComponent.action);
            }
            String scheme = urlComponent.req.getScheme();
            if (urlComponent.scheme != null) {
                scheme = urlComponent.scheme;
            }
            urlComponent.namespace = urlComponent.determineNamespace(urlComponent.namespace, urlComponent.stack, urlComponent.req);
            String result = this.onlyActionSpecified(urlComponent) ? PortletUrlHelper.buildUrl(action, urlComponent.namespace, urlComponent.method, urlComponent.parameters, urlComponent.portletUrlType, urlComponent.portletMode, urlComponent.windowState) : (this.onlyValueSpecified(urlComponent) ? PortletUrlHelper.buildResourceUrl(urlComponent.value, urlComponent.parameters) : this.createDefaultUrl(urlComponent));
            if (urlComponent.anchor != null && urlComponent.anchor.length() > 0) {
                result = result + '#' + urlComponent.findString(urlComponent.anchor);
            }
            if ((var = urlComponent.getVar()) != null) {
                urlComponent.putInContext((Object)result);
                urlComponent.req.setAttribute(var, (Object)result);
            } else {
                try {
                    writer.write(result);
                }
                catch (IOException e) {
                    throw new StrutsException("IOError: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private String createDefaultUrl(URL urlComponent) {
        ActionInvocation ai = (ActionInvocation)urlComponent.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
        String action = ai.getProxy().getActionName();
        String result = PortletUrlHelper.buildUrl(action, urlComponent.namespace, urlComponent.method, urlComponent.parameters, urlComponent.portletUrlType, urlComponent.portletMode, urlComponent.windowState);
        return result;
    }

    private boolean onlyValueSpecified(URL urlComponent) {
        return urlComponent.value != null && urlComponent.action == null;
    }

    private boolean onlyActionSpecified(URL urlComponent) {
        return urlComponent.value == null && urlComponent.action != null;
    }

    public void renderFormUrl(Form formComponent) {
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.renderFormUrl(formComponent);
        } else {
            String namespace = formComponent.determineNamespace(formComponent.namespace, formComponent.getStack(), formComponent.request);
            String action = null;
            if (formComponent.action != null) {
                action = formComponent.findString(formComponent.action);
            } else {
                ActionInvocation ai = (ActionInvocation)formComponent.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
                action = ai.getProxy().getActionName();
            }
            String type = "action";
            if (TextUtils.stringSet((String)formComponent.method) && "GET".equalsIgnoreCase(formComponent.method.trim())) {
                type = "render";
            }
            if (action != null) {
                String result = PortletUrlHelper.buildUrl(action, namespace, null, formComponent.getParameters(), type, formComponent.portletMode, formComponent.windowState);
                formComponent.addParameter("action", (Object)result);
                String id = formComponent.getId();
                if (id == null) {
                    int slash = action.lastIndexOf(47);
                    int dot = action.indexOf(46, slash);
                    id = dot != -1 ? action.substring(slash + 1, dot) : action.substring(slash + 1);
                    formComponent.addParameter("id", (Object)formComponent.escape(id));
                }
            }
        }
    }

    public void beforeRenderUrl(URL urlComponent) {
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.beforeRenderUrl(urlComponent);
        }
    }

    public void setServletRenderer(UrlRenderer nonPortletRenderer) {
        this.servletRenderer = nonPortletRenderer;
    }
}

