/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config_browser;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ResolverUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelper {
    private Configuration configuration;

    @Inject
    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Set<String> getNamespaces() {
        Set<String> namespaces = Collections.emptySet();
        Map allActionConfigs = this.configuration.getRuntimeConfiguration().getActionConfigs();
        if (allActionConfigs != null) {
            namespaces = allActionConfigs.keySet();
        }
        return namespaces;
    }

    public Set<String> getActionNames(String namespace) {
        Map actionMappings;
        Set<String> actionNames = Collections.emptySet();
        Map allActionConfigs = this.configuration.getRuntimeConfiguration().getActionConfigs();
        if (allActionConfigs != null && (actionMappings = (Map)allActionConfigs.get(namespace)) != null) {
            actionNames = actionMappings.keySet();
        }
        return actionNames;
    }

    public ActionConfig getActionConfig(String namespace, String actionName) {
        Map actionMappings;
        ActionConfig config = null;
        Map allActionConfigs = this.configuration.getRuntimeConfiguration().getActionConfigs();
        if (allActionConfigs != null && (actionMappings = (Map)allActionConfigs.get(namespace)) != null) {
            config = (ActionConfig)actionMappings.get(actionName);
        }
        return config;
    }

    public List<Properties> getJarProperties() throws IOException {
        ResolverUtil resolver = new ResolverUtil();
        ArrayList<Properties> poms = new ArrayList<Properties>();
        resolver.findNamedResource("pom.properties", new String[]{"META-INF/maven"});
        Set urls = resolver.getResources();
        for (URL url : urls) {
            Properties p = new Properties();
            p.load(url.openStream());
            poms.add(p);
        }
        return poms;
    }
}

