/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public abstract class SolrRequest<T extends SolrResponse>
implements Serializable {
    private METHOD method = METHOD.GET;
    private String path = null;
    private ResponseParser responseParser;
    private StreamingResponseCallback callback;
    private Set<String> queryParams;
    private String basicAuthUser;
    private String basicAuthPwd;

    public SolrRequest setBasicAuthCredentials(String user, String password) {
        this.basicAuthUser = user;
        this.basicAuthPwd = password;
        return this;
    }

    public String getBasicAuthUser() {
        return this.basicAuthUser;
    }

    public String getBasicAuthPassword() {
        return this.basicAuthPwd;
    }

    public SolrRequest(METHOD m, String path) {
        this.method = m;
        this.path = path;
    }

    public METHOD getMethod() {
        return this.method;
    }

    public void setMethod(METHOD method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ResponseParser getResponseParser() {
        return this.responseParser;
    }

    public void setResponseParser(ResponseParser responseParser) {
        this.responseParser = responseParser;
    }

    public StreamingResponseCallback getStreamingResponseCallback() {
        return this.callback;
    }

    public void setStreamingResponseCallback(StreamingResponseCallback callback) {
        this.callback = callback;
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Set<String> queryParams) {
        this.queryParams = queryParams;
    }

    public abstract SolrParams getParams();

    public abstract Collection<ContentStream> getContentStreams() throws IOException;

    protected abstract T createResponse(SolrClient var1);

    public final T process(SolrClient client, String collection) throws SolrServerException, IOException {
        long startTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        T res = this.createResponse(client);
        ((SolrResponse)res).setResponse(client.request(this, collection));
        long endTime = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        ((SolrResponse)res).setElapsedTime(endTime - startTime);
        return res;
    }

    public final T process(SolrClient client) throws SolrServerException, IOException {
        return this.process(client, null);
    }

    public static enum METHOD {
        GET,
        POST,
        PUT;

    }
}

