/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ByteUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateReader {
    private static Logger log = LoggerFactory.getLogger(ZkStateReader.class);
    public static final String BASE_URL_PROP = "base_url";
    public static final String NODE_NAME_PROP = "node_name";
    public static final String CORE_NODE_NAME_PROP = "core_node_name";
    public static final String ROLES_PROP = "roles";
    public static final String STATE_PROP = "state";
    public static final String CORE_NAME_PROP = "core";
    public static final String COLLECTION_PROP = "collection";
    public static final String SHARD_ID_PROP = "shard";
    public static final String SHARD_RANGE_PROP = "shard_range";
    public static final String SHARD_STATE_PROP = "shard_state";
    public static final String NUM_SHARDS_PROP = "numShards";
    public static final String LEADER_PROP = "leader";
    public static final String COLLECTIONS_ZKNODE = "/collections";
    public static final String LIVE_NODES_ZKNODE = "/live_nodes";
    public static final String ALIASES = "/aliases.json";
    public static final String CLUSTER_STATE = "/clusterstate.json";
    public static final String RECOVERING = "recovering";
    public static final String RECOVERY_FAILED = "recovery_failed";
    public static final String ACTIVE = "active";
    public static final String DOWN = "down";
    public static final String SYNC = "sync";
    private volatile ClusterState clusterState;
    private static final long SOLRCLOUD_UPDATE_DELAY = Long.parseLong(System.getProperty("solrcloud.update.delay", "5000"));
    public static final String LEADER_ELECT_ZKNODE = "/leader_elect";
    public static final String SHARD_LEADERS_ZKNODE = "leaders";
    private ScheduledExecutorService updateCloudExecutor = Executors.newScheduledThreadPool(1, new ZKTF());
    private boolean clusterStateUpdateScheduled;
    private SolrZkClient zkClient;
    private boolean closeClient = false;
    private ZkCmdExecutor cmdExecutor;
    private Aliases aliases = new Aliases();
    private volatile boolean closed = false;

    public static byte[] toJSON(Object o) {
        CharArr out = new CharArr();
        new JSONWriter(out, 2).write(o);
        return ZkStateReader.toUTF8(out);
    }

    public static byte[] toUTF8(CharArr out) {
        byte[] arr = new byte[out.size() << 2];
        int nBytes = ByteUtils.UTF16toUTF8((CharSequence)out, 0, out.size(), arr, 0);
        return Arrays.copyOf(arr, nBytes);
    }

    public static Object fromJSON(byte[] utf8) {
        CharArr chars = new CharArr();
        ByteUtils.UTF8toUTF16(utf8, 0, utf8.length, chars);
        JSONParser parser = new JSONParser(chars.getArray(), chars.getStart(), chars.length());
        try {
            return ObjectBuilder.getVal((JSONParser)parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ZkStateReader(SolrZkClient zkClient) {
        this.zkClient = zkClient;
        this.initZkCmdExecutor(zkClient.getZkClientTimeout());
    }

    public ZkStateReader(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout) throws InterruptedException, TimeoutException, IOException {
        this.closeClient = true;
        this.initZkCmdExecutor(zkClientTimeout);
        this.zkClient = new SolrZkClient(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new OnReconnect(){

            @Override
            public void command() {
                try {
                    ZkStateReader.this.createClusterStateWatchersAndUpdate();
                }
                catch (KeeperException e) {
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
            }
        });
    }

    private void initZkCmdExecutor(int zkClientTimeout) {
        this.cmdExecutor = new ZkCmdExecutor(zkClientTimeout);
    }

    public void updateClusterState(boolean immediate) throws KeeperException, InterruptedException {
        this.updateClusterState(immediate, false);
    }

    public void updateLiveNodes() throws KeeperException, InterruptedException {
        this.updateClusterState(true, true);
    }

    public Aliases getAliases() {
        return this.aliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createClusterStateWatchersAndUpdate() throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            this.cmdExecutor.ensureExists(CLUSTER_STATE, this.zkClient);
            this.cmdExecutor.ensureExists(ALIASES, this.zkClient);
            log.info("Updating cluster state from ZooKeeper... ");
            this.zkClient.exists(CLUSTER_STATE, new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    log.info("A cluster state change: {}, has occurred - updating... (live nodes size: {})", (Object)event, (Object)(ZkStateReader.this.clusterState == null ? 0 : ZkStateReader.this.clusterState.getLiveNodes().size()));
                    try {
                        Object object = ZkStateReader.this.getUpdateLock();
                        synchronized (object) {
                            2 thisWatch = this;
                            Stat stat = new Stat();
                            byte[] data = ZkStateReader.this.zkClient.getData(ZkStateReader.CLUSTER_STATE, thisWatch, stat, true);
                            List<String> liveNodes = ZkStateReader.this.zkClient.getChildren(ZkStateReader.LIVE_NODES_ZKNODE, this, true);
                            HashSet<String> liveNodesSet = new HashSet<String>();
                            liveNodesSet.addAll(liveNodes);
                            Set<String> ln = ZkStateReader.this.clusterState.getLiveNodes();
                            ClusterState clusterState = ClusterState.load(stat.getVersion(), data, ln);
                            ZkStateReader.this.clusterState = clusterState;
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                        return;
                    }
                }
            }, true);
        }
        object = this.getUpdateLock();
        synchronized (object) {
            ClusterState clusterState;
            List<String> liveNodes = this.zkClient.getChildren(LIVE_NODES_ZKNODE, new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    try {
                        Object object = ZkStateReader.this.getUpdateLock();
                        synchronized (object) {
                            List<String> liveNodes = ZkStateReader.this.zkClient.getChildren(ZkStateReader.LIVE_NODES_ZKNODE, this, true);
                            log.info("Updating live nodes... ({})", (Object)liveNodes.size());
                            HashSet<String> liveNodesSet = new HashSet<String>();
                            liveNodesSet.addAll(liveNodes);
                            ClusterState clusterState = new ClusterState(ZkStateReader.this.clusterState.getZkClusterStateVersion(), liveNodesSet, ZkStateReader.this.clusterState.getCollectionStates());
                            ZkStateReader.this.clusterState = clusterState;
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                        return;
                    }
                }
            }, true);
            HashSet<String> liveNodeSet = new HashSet<String>();
            liveNodeSet.addAll(liveNodes);
            this.clusterState = clusterState = ClusterState.load(this.zkClient, liveNodeSet);
            this.zkClient.exists(ALIASES, new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    try {
                        Object object = ZkStateReader.this.getUpdateLock();
                        synchronized (object) {
                            log.info("Updating aliases... ");
                            4 thisWatch = this;
                            Stat stat = new Stat();
                            byte[] data = ZkStateReader.this.zkClient.getData(ZkStateReader.ALIASES, thisWatch, stat, true);
                            Aliases aliases = ClusterState.load(data);
                            ZkStateReader.this.aliases = aliases;
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                        return;
                    }
                }
            }, true);
        }
        this.updateAliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateClusterState(boolean immediate, final boolean onlyLiveNodes) throws KeeperException, InterruptedException {
        if (immediate) {
            Object object = this.getUpdateLock();
            synchronized (object) {
                ClusterState clusterState;
                List<String> liveNodes = this.zkClient.getChildren(LIVE_NODES_ZKNODE, null, true);
                HashSet<String> liveNodesSet = new HashSet<String>();
                liveNodesSet.addAll(liveNodes);
                if (!onlyLiveNodes) {
                    log.info("Updating cloud state from ZooKeeper... ");
                    clusterState = ClusterState.load(this.zkClient, liveNodesSet);
                } else {
                    log.info("Updating live nodes from ZooKeeper... ({})", (Object)liveNodesSet.size());
                    clusterState = new ClusterState(this.clusterState.getZkClusterStateVersion(), liveNodesSet, this.clusterState.getCollectionStates());
                }
                this.clusterState = clusterState;
            }
        } else {
            if (this.clusterStateUpdateScheduled) {
                log.info("Cloud state update for ZooKeeper already scheduled");
                return;
            }
            log.info("Scheduling cloud state update from ZooKeeper...");
            this.clusterStateUpdateScheduled = true;
            this.updateCloudExecutor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    log.info("Updating cluster state from ZooKeeper...");
                    Object object = ZkStateReader.this.getUpdateLock();
                    synchronized (object) {
                        ClusterState clusterState;
                        ZkStateReader.this.clusterStateUpdateScheduled = false;
                        try {
                            List<String> liveNodes = ZkStateReader.this.zkClient.getChildren(ZkStateReader.LIVE_NODES_ZKNODE, null, true);
                            HashSet<String> liveNodesSet = new HashSet<String>();
                            liveNodesSet.addAll(liveNodes);
                            if (!onlyLiveNodes) {
                                log.info("Updating cloud state from ZooKeeper... ");
                                clusterState = ClusterState.load(ZkStateReader.this.zkClient, liveNodesSet);
                            } else {
                                log.info("Updating live nodes from ZooKeeper... ");
                                clusterState = new ClusterState(ZkStateReader.this.clusterState.getZkClusterStateVersion(), liveNodesSet, ZkStateReader.this.clusterState.getCollectionStates());
                            }
                            ZkStateReader.this.clusterState = clusterState;
                        }
                        catch (KeeperException e) {
                            if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                                return;
                            }
                            log.error("", (Throwable)e);
                            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.error("", (Throwable)e);
                            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                        }
                        ZkStateReader.this.clusterState = clusterState;
                    }
                }
            }, SOLRCLOUD_UPDATE_DELAY, TimeUnit.MILLISECONDS);
        }
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public Object getUpdateLock() {
        return this;
    }

    public void close() {
        this.closed = true;
        if (this.closeClient) {
            this.zkClient.close();
        }
    }

    public String getLeaderUrl(String collection, String shard, int timeout) throws InterruptedException, KeeperException {
        ZkCoreNodeProps props = new ZkCoreNodeProps(this.getLeaderRetry(collection, shard, timeout));
        return props.getCoreUrl();
    }

    public Replica getLeaderRetry(String collection, String shard) throws InterruptedException {
        return this.getLeaderRetry(collection, shard, 1000);
    }

    public Replica getLeaderRetry(String collection, String shard, int timeout) throws InterruptedException {
        long timeoutAt = System.currentTimeMillis() + (long)timeout;
        while (System.currentTimeMillis() < timeoutAt && !this.closed) {
            Replica replica;
            if (this.clusterState != null && (replica = this.clusterState.getLeader(collection, shard)) != null && this.getClusterState().liveNodesContain(replica.getNodeName())) {
                return replica;
            }
            Thread.sleep(50L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No registered leader was found, collection:" + collection + " slice:" + shard);
    }

    public static String getShardLeadersPath(String collection, String shardId) {
        return "/collections/" + collection + "/" + SHARD_LEADERS_ZKNODE + (shardId != null ? "/" + shardId : "");
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, String coreName) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, coreName, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, String coreName, String mustMatchStateFilter) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, coreName, mustMatchStateFilter, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, String coreName, String mustMatchStateFilter, String mustNotMatchStateFilter) {
        ClusterState clusterState = this.clusterState;
        if (clusterState == null) {
            return null;
        }
        Map<String, Slice> slices = clusterState.getSlicesMap(collection);
        if (slices == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + collection + " " + clusterState.getCollections());
        }
        Slice replicas = slices.get(shardId);
        if (replicas == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find shardId in zk: " + shardId);
        }
        Map<String, Replica> shardMap = replicas.getReplicasMap();
        ArrayList<ZkCoreNodeProps> nodes = new ArrayList<ZkCoreNodeProps>(shardMap.size());
        for (Map.Entry<String, Replica> entry : shardMap.entrySet()) {
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps(entry.getValue());
            String coreNodeName = entry.getValue().getName();
            if (!clusterState.liveNodesContain(nodeProps.getNodeName()) || coreNodeName.equals(thisCoreNodeName) || mustMatchStateFilter != null && !mustMatchStateFilter.equals(nodeProps.getState()) || mustNotMatchStateFilter != null && mustNotMatchStateFilter.equals(nodeProps.getState())) continue;
            nodes.add(nodeProps);
        }
        if (nodes.size() == 0) {
            return null;
        }
        return nodes;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public void updateAliases() throws KeeperException, InterruptedException {
        Aliases aliases;
        byte[] data = this.zkClient.getData(ALIASES, null, null, true);
        this.aliases = aliases = ClusterState.load(data);
    }

    abstract class RunnableWatcher
    implements Runnable {
        Watcher watcher;

        public RunnableWatcher(Watcher watcher) {
            this.watcher = watcher;
        }
    }

    private static class ZKTF
    implements ThreadFactory {
        private static ThreadGroup tg = new ThreadGroup("ZkStateReader");

        private ZKTF() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread td = new Thread(tg, r);
            td.setDaemon(true);
            return td;
        }
    }
}

