/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;

public class LBHttpSolrServer
extends SolrServer {
    private final Map<String, ServerWrapper> aliveServers = new LinkedHashMap<String, ServerWrapper>();
    private final Map<String, ServerWrapper> zombieServers = new ConcurrentHashMap<String, ServerWrapper>();
    private volatile ServerWrapper[] aliveServerList = new ServerWrapper[0];
    private ScheduledExecutorService aliveCheckExecutor;
    private final HttpClient httpClient;
    private final boolean clientIsInternal;
    private final AtomicInteger counter = new AtomicInteger(-1);
    private static final SolrQuery solrQuery = new SolrQuery("*:*");
    private final ResponseParser parser;
    private int interval = 60000;
    private static final int CHECK_INTERVAL = 60000;
    private static final int NONSTANDARD_PING_LIMIT = 5;

    public LBHttpSolrServer(String ... solrServerUrls) throws MalformedURLException {
        this((HttpClient)null, solrServerUrls);
    }

    public LBHttpSolrServer(HttpClient httpClient, String ... solrServerUrl) throws MalformedURLException {
        this(httpClient, new BinaryResponseParser(), solrServerUrl);
    }

    public LBHttpSolrServer(HttpClient httpClient, ResponseParser parser, String ... solrServerUrl) throws MalformedURLException {
        this.clientIsInternal = httpClient == null;
        this.parser = parser;
        if (httpClient == null) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("retry", false);
            this.httpClient = HttpClientUtil.createClient(params);
        } else {
            this.httpClient = httpClient;
        }
        for (String s : solrServerUrl) {
            ServerWrapper wrapper = new ServerWrapper(this.makeServer(s));
            this.aliveServers.put(wrapper.getKey(), wrapper);
        }
        this.updateAliveList();
    }

    public static String normalize(String server) {
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        return server;
    }

    protected HttpSolrServer makeServer(String server) throws MalformedURLException {
        return new HttpSolrServer(server, this.httpClient, this.parser);
    }

    public Rsp request(Req req) throws SolrServerException, IOException {
        Rsp rsp = new Rsp();
        Exception ex = null;
        ArrayList<ServerWrapper> skipped = new ArrayList<ServerWrapper>(req.getNumDeadServersToTry());
        for (String serverStr : req.getServers()) {
            ServerWrapper wrapper = this.zombieServers.get(serverStr = LBHttpSolrServer.normalize(serverStr));
            if (wrapper != null) {
                if (skipped.size() >= req.getNumDeadServersToTry()) continue;
                skipped.add(wrapper);
                continue;
            }
            rsp.server = serverStr;
            HttpSolrServer server = this.makeServer(serverStr);
            try {
                rsp.rsp = server.request(req.getRequest());
                return rsp;
            }
            catch (SolrException e) {
                if (e.code() == 404 || e.code() == 403 || e.code() == 503 || e.code() == 500) {
                    ex = this.addZombie(server, e);
                    continue;
                }
                throw e;
            }
            catch (SocketException e) {
                ex = this.addZombie(server, e);
            }
            catch (SocketTimeoutException e) {
                ex = this.addZombie(server, e);
            }
            catch (SolrServerException e) {
                Throwable rootCause = e.getRootCause();
                if (rootCause instanceof IOException) {
                    ex = this.addZombie(server, e);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        for (ServerWrapper wrapper : skipped) {
            try {
                rsp.rsp = wrapper.solrServer.request(req.getRequest());
                this.zombieServers.remove(wrapper.getKey());
                return rsp;
            }
            catch (SolrException e) {
                if (e.code() == 404 || e.code() == 403 || e.code() == 503 || e.code() == 500) {
                    ex = e;
                    continue;
                }
                this.zombieServers.remove(wrapper.getKey());
                throw e;
            }
            catch (SocketException e) {
                ex = e;
            }
            catch (SocketTimeoutException e) {
                ex = e;
            }
            catch (SolrServerException e) {
                Throwable rootCause = e.getRootCause();
                if (rootCause instanceof IOException) {
                    ex = e;
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        if (ex == null) {
            throw new SolrServerException("No live SolrServers available to handle this request");
        }
        throw new SolrServerException("No live SolrServers available to handle this request:" + this.zombieServers.keySet(), ex);
    }

    private Exception addZombie(HttpSolrServer server, Exception e) {
        ServerWrapper wrapper = new ServerWrapper(server);
        wrapper.lastUsed = System.currentTimeMillis();
        wrapper.standard = false;
        this.zombieServers.put(wrapper.getKey(), wrapper);
        this.startAliveCheckExecutor();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAliveList() {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            this.aliveServerList = this.aliveServers.values().toArray(new ServerWrapper[this.aliveServers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerWrapper removeFromAlive(String key) {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            ServerWrapper wrapper = this.aliveServers.remove(key);
            if (wrapper != null) {
                this.updateAliveList();
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAlive(ServerWrapper wrapper) {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            ServerWrapper prev = this.aliveServers.put(wrapper.getKey(), wrapper);
            this.updateAliveList();
        }
    }

    public void addSolrServer(String server) throws MalformedURLException {
        HttpSolrServer solrServer = this.makeServer(server);
        this.addToAlive(new ServerWrapper(solrServer));
    }

    public String removeSolrServer(String server) {
        try {
            server = new URL(server).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        this.removeFromAlive(server);
        this.zombieServers.remove(server);
        return null;
    }

    public void setConnectionTimeout(int timeout) {
        HttpClientUtil.setConnectionTimeout(this.httpClient, timeout);
    }

    public void setSoTimeout(int timeout) {
        HttpClientUtil.setSoTimeout(this.httpClient, timeout);
    }

    @Override
    public void shutdown() {
        if (this.aliveCheckExecutor != null) {
            this.aliveCheckExecutor.shutdownNow();
        }
        if (this.clientIsInternal) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        SolrServerException ex = null;
        ServerWrapper[] serverList = this.aliveServerList;
        int maxTries = serverList.length;
        HashMap<String, ServerWrapper> justFailed = null;
        for (int attempts = 0; attempts < maxTries; ++attempts) {
            int count = this.counter.incrementAndGet();
            ServerWrapper wrapper = serverList[count % serverList.length];
            wrapper.lastUsed = System.currentTimeMillis();
            try {
                return wrapper.solrServer.request(request);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    this.moveAliveToDead(wrapper);
                    if (justFailed == null) {
                        justFailed = new HashMap<String, ServerWrapper>();
                    }
                    justFailed.put(wrapper.getKey(), wrapper);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        for (ServerWrapper wrapper : this.zombieServers.values()) {
            if (!wrapper.standard || justFailed != null && justFailed.containsKey(wrapper.getKey())) continue;
            try {
                NamedList<Object> rsp = wrapper.solrServer.request(request);
                this.zombieServers.remove(wrapper.getKey());
                this.addToAlive(wrapper);
                return rsp;
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        if (ex == null) {
            throw new SolrServerException("No live SolrServers available to handle this request");
        }
        throw new SolrServerException("No live SolrServers available to handle this request", ex);
    }

    private void checkAZombieServer(ServerWrapper zombieServer) {
        block4: {
            long currTime = System.currentTimeMillis();
            try {
                ServerWrapper wrapper;
                zombieServer.lastChecked = currTime;
                QueryResponse resp = zombieServer.solrServer.query(solrQuery);
                if (resp.getStatus() == 0 && (wrapper = this.zombieServers.remove(zombieServer.getKey())) != null) {
                    wrapper.failedPings = 0;
                    if (wrapper.standard) {
                        this.addToAlive(wrapper);
                    }
                }
            }
            catch (Exception e) {
                ++zombieServer.failedPings;
                if (zombieServer.standard || zombieServer.failedPings < 5) break block4;
                this.zombieServers.remove(zombieServer.getKey());
            }
        }
    }

    private void moveAliveToDead(ServerWrapper wrapper) {
        if ((wrapper = this.removeFromAlive(wrapper.getKey())) == null) {
            return;
        }
        this.zombieServers.put(wrapper.getKey(), wrapper);
        this.startAliveCheckExecutor();
    }

    public void setAliveCheckInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + interval);
        }
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAliveCheckExecutor() {
        if (this.aliveCheckExecutor == null) {
            LBHttpSolrServer lBHttpSolrServer = this;
            synchronized (lBHttpSolrServer) {
                if (this.aliveCheckExecutor == null) {
                    this.aliveCheckExecutor = Executors.newSingleThreadScheduledExecutor(new SolrjNamedThreadFactory("aliveCheckExecutor"));
                    this.aliveCheckExecutor.scheduleAtFixedRate(LBHttpSolrServer.getAliveCheckRunner(new WeakReference<LBHttpSolrServer>(this)), this.interval, this.interval, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private static Runnable getAliveCheckRunner(final WeakReference<LBHttpSolrServer> lbRef) {
        return new Runnable(){

            @Override
            public void run() {
                LBHttpSolrServer lb = (LBHttpSolrServer)lbRef.get();
                if (lb != null && lb.zombieServers != null) {
                    for (ServerWrapper zombieServer : lb.zombieServers.values()) {
                        lb.checkAZombieServer(zombieServer);
                    }
                }
            }
        };
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.aliveCheckExecutor != null) {
                this.aliveCheckExecutor.shutdownNow();
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        solrQuery.setRows(0);
    }

    public static class Rsp {
        protected String server;
        protected NamedList<Object> rsp;

        public NamedList<Object> getResponse() {
            return this.rsp;
        }

        public String getServer() {
            return this.server;
        }
    }

    public static class Req {
        protected SolrRequest request;
        protected List<String> servers;
        protected int numDeadServersToTry;

        public Req(SolrRequest request, List<String> servers) {
            this.request = request;
            this.servers = servers;
            this.numDeadServersToTry = servers.size();
        }

        public SolrRequest getRequest() {
            return this.request;
        }

        public List<String> getServers() {
            return this.servers;
        }

        public int getNumDeadServersToTry() {
            return this.numDeadServersToTry;
        }

        public void setNumDeadServersToTry(int numDeadServersToTry) {
            this.numDeadServersToTry = numDeadServersToTry;
        }
    }

    private static class ServerWrapper {
        final HttpSolrServer solrServer;
        long lastUsed;
        long lastChecked;
        boolean standard = true;
        int failedPings = 0;

        public ServerWrapper(HttpSolrServer solrServer) {
            this.solrServer = solrServer;
        }

        public String toString() {
            return this.solrServer.getBaseURL();
        }

        public String getKey() {
            return this.solrServer.getBaseURL();
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServerWrapper)) {
                return false;
            }
            return this.getKey().equals(((ServerWrapper)obj).getKey());
        }
    }
}

