/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.noggit.JSONUtil;
import org.apache.noggit.JSONWriter;
import org.apache.solr.common.cloud.HashPartitioner;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkNodeProps;

public class Slice
extends ZkNodeProps {
    public static String REPLICAS = "replicas";
    public static String RANGE = "range";
    public static String LEADER = "leader";
    private final String name;
    private final HashPartitioner.Range range;
    private final Integer replicationFactor;
    private final Map<String, Replica> replicas;
    private final Replica leader;

    public Slice(String name, Map<String, Replica> replicas, Map<String, Object> props) {
        super(props == null ? new LinkedHashMap<String, Object>(2) : new LinkedHashMap<String, Object>(props));
        this.name = name;
        Object rangeObj = this.propMap.get(RANGE);
        HashPartitioner.Range tmpRange = null;
        if (rangeObj instanceof HashPartitioner.Range) {
            tmpRange = (HashPartitioner.Range)rangeObj;
        } else if (rangeObj != null) {
            HashPartitioner hp = new HashPartitioner();
            tmpRange = hp.fromString(rangeObj.toString());
        }
        this.range = tmpRange;
        this.replicationFactor = null;
        this.replicas = replicas != null ? replicas : this.makeReplicas((Map)this.propMap.get(REPLICAS));
        this.propMap.put(REPLICAS, this.replicas);
        this.leader = this.findLeader();
    }

    private Map<String, Replica> makeReplicas(Map<String, Object> genericReplicas) {
        if (genericReplicas == null) {
            return new HashMap<String, Replica>(1);
        }
        LinkedHashMap<String, Replica> result = new LinkedHashMap<String, Replica>(genericReplicas.size());
        for (Map.Entry<String, Object> entry : genericReplicas.entrySet()) {
            String name = entry.getKey();
            Object val = entry.getValue();
            Replica r = val instanceof Replica ? (Replica)val : new Replica(name, (Map)val);
            result.put(name, r);
        }
        return result;
    }

    private Replica findLeader() {
        for (Replica replica : this.replicas.values()) {
            if (replica.getStr(LEADER) == null) continue;
            return replica;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Replica> getReplicas() {
        return this.replicas.values();
    }

    public Map<String, Replica> getReplicasMap() {
        return this.replicas;
    }

    public Map<String, Replica> getReplicasCopy() {
        return new LinkedHashMap<String, Replica>(this.replicas);
    }

    public Replica getLeader() {
        return this.leader;
    }

    @Override
    public String toString() {
        return this.name + ':' + JSONUtil.toJSON(this.propMap);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.propMap);
    }
}

