/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.noggit.JSONWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.HashPartitioner;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterState
implements JSONWriter.Writable {
    private static Logger log = LoggerFactory.getLogger(ClusterState.class);
    private Integer zkClusterStateVersion;
    private final Map<String, Map<String, Slice>> collectionStates;
    private final Set<String> liveNodes;
    private final HashPartitioner hp = new HashPartitioner();
    private final Map<String, RangeInfo> rangeInfos = new HashMap<String, RangeInfo>();
    private final Map<String, Map<String, ZkNodeProps>> leaders = new HashMap<String, Map<String, ZkNodeProps>>();

    public ClusterState(Set<String> liveNodes, Map<String, Map<String, Slice>> collectionStates) {
        this(null, liveNodes, collectionStates);
    }

    public ClusterState(Integer zkClusterStateVersion, Set<String> liveNodes, Map<String, Map<String, Slice>> collectionStates) {
        this.liveNodes = new HashSet<String>(liveNodes.size());
        this.liveNodes.addAll(liveNodes);
        this.collectionStates = new HashMap<String, Map<String, Slice>>(collectionStates.size());
        this.collectionStates.putAll(collectionStates);
        this.addRangeInfos(collectionStates.keySet());
        this.getShardLeaders();
    }

    private void getShardLeaders() {
        Set<Map.Entry<String, Map<String, Slice>>> collections = this.collectionStates.entrySet();
        for (Map.Entry<String, Map<String, Slice>> collection : collections) {
            Map<String, Slice> state = collection.getValue();
            Set<Map.Entry<String, Slice>> slices = state.entrySet();
            block1: for (Map.Entry<String, Slice> sliceEntry : slices) {
                Slice slice = sliceEntry.getValue();
                Map<String, Replica> shards = slice.getReplicasMap();
                Set<Map.Entry<String, Replica>> shardsEntries = shards.entrySet();
                for (Map.Entry<String, Replica> shardEntry : shardsEntries) {
                    ZkNodeProps props = shardEntry.getValue();
                    if (!props.containsKey("leader")) continue;
                    Map<String, ZkNodeProps> leadersForCollection = this.leaders.get(collection.getKey());
                    if (leadersForCollection == null) {
                        leadersForCollection = new HashMap<String, ZkNodeProps>();
                        this.leaders.put(collection.getKey(), leadersForCollection);
                    }
                    leadersForCollection.put(sliceEntry.getKey(), props);
                    continue block1;
                }
            }
        }
    }

    public ZkNodeProps getLeader(String collection, String shard) {
        Map<String, ZkNodeProps> collectionLeaders = this.leaders.get(collection);
        if (collectionLeaders == null) {
            return null;
        }
        return collectionLeaders.get(shard);
    }

    public Replica getShardProps(String collection, String coreNodeName) {
        Map<String, Slice> slices = this.getSlices(collection);
        for (Slice slice : slices.values()) {
            if (slice.getReplicasMap().get(coreNodeName) == null) continue;
            return slice.getReplicasMap().get(coreNodeName);
        }
        return null;
    }

    private void addRangeInfos(Set<String> collections) {
        for (String collection : collections) {
            this.addRangeInfo(collection);
        }
    }

    public Slice getSlice(String collection, String slice) {
        if (this.collectionStates.containsKey(collection) && this.collectionStates.get(collection).containsKey(slice)) {
            return this.collectionStates.get(collection).get(slice);
        }
        return null;
    }

    public Map<String, Slice> getSlices(String collection) {
        if (!this.collectionStates.containsKey(collection)) {
            return null;
        }
        return Collections.unmodifiableMap(this.collectionStates.get(collection));
    }

    public Set<String> getCollections() {
        return Collections.unmodifiableSet(this.collectionStates.keySet());
    }

    public Map<String, Map<String, Slice>> getCollectionStates() {
        return Collections.unmodifiableMap(this.collectionStates);
    }

    public Set<String> getLiveNodes() {
        return Collections.unmodifiableSet(this.liveNodes);
    }

    public String getShardId(String coreNodeName) {
        for (Map.Entry<String, Map<String, Slice>> states : this.collectionStates.entrySet()) {
            for (Map.Entry<String, Slice> slices : states.getValue().entrySet()) {
                for (Map.Entry<String, Replica> shards : slices.getValue().getReplicasMap().entrySet()) {
                    if (!coreNodeName.equals(shards.getKey())) continue;
                    return slices.getKey();
                }
            }
        }
        return null;
    }

    public boolean liveNodesContain(String name) {
        return this.liveNodes.contains(name);
    }

    public RangeInfo getRanges(String collection) {
        RangeInfo rangeInfo = this.rangeInfos.get(collection);
        return rangeInfo;
    }

    private RangeInfo addRangeInfo(String collection) {
        RangeInfo rangeInfo = new RangeInfo();
        Map<String, Slice> slices = this.getSlices(collection);
        if (slices == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find collection " + collection + " in " + this);
        }
        Set<String> shards = slices.keySet();
        ArrayList<String> shardList = new ArrayList<String>(shards.size());
        shardList.addAll(shards);
        Collections.sort(shardList);
        List<HashPartitioner.Range> ranges = this.hp.partitionRange(shards.size(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        rangeInfo.ranges = ranges;
        rangeInfo.shardList = shardList;
        this.rangeInfos.put(collection, rangeInfo);
        return rangeInfo;
    }

    public String getShard(int hash, String collection) {
        RangeInfo rangInfo = this.getRanges(collection);
        int cnt = 0;
        for (HashPartitioner.Range range : rangInfo.ranges) {
            if (range.includes(hash)) {
                return (String)rangInfo.shardList.get(cnt);
            }
            ++cnt;
        }
        throw new IllegalStateException("The HashPartitioner failed");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("live nodes:" + this.liveNodes);
        sb.append(" collections:" + this.collectionStates);
        return sb.toString();
    }

    public static ClusterState load(SolrZkClient zkClient, Set<String> liveNodes) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        byte[] state = zkClient.getData("/clusterstate.json", null, stat, true);
        return ClusterState.load(stat.getVersion(), state, liveNodes);
    }

    public static ClusterState load(Integer version, byte[] bytes, Set<String> liveNodes) {
        if (bytes == null || bytes.length == 0) {
            return new ClusterState(version, liveNodes, Collections.<String, Map<String, Slice>>emptyMap());
        }
        LinkedHashMap stateMap = (LinkedHashMap)ZkStateReader.fromJSON(bytes);
        HashMap<String, Map<String, Slice>> state = new HashMap<String, Map<String, Slice>>();
        for (String collectionName : stateMap.keySet()) {
            Map collection = (Map)stateMap.get(collectionName);
            LinkedHashMap<String, Slice> slices = new LinkedHashMap<String, Slice>();
            for (Map.Entry sliceEntry : collection.entrySet()) {
                Slice slice = new Slice((String)sliceEntry.getKey(), null, (Map)sliceEntry.getValue());
                slices.put(slice.getName(), slice);
            }
            state.put(collectionName, slices);
        }
        return new ClusterState(version, liveNodes, state);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.collectionStates);
    }

    public Integer getZkClusterStateVersion() {
        return this.zkClusterStateVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.zkClusterStateVersion == null ? 0 : this.zkClusterStateVersion.hashCode());
        result = 31 * result + (this.liveNodes == null ? 0 : ((Object)this.liveNodes).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterState other = (ClusterState)obj;
        if (this.zkClusterStateVersion == null ? other.zkClusterStateVersion != null : !this.zkClusterStateVersion.equals(other.zkClusterStateVersion)) {
            return false;
        }
        return !(this.liveNodes == null ? other.liveNodes != null : !((Object)this.liveNodes).equals(other.liveNodes));
    }

    private class RangeInfo {
        private List<HashPartitioner.Range> ranges;
        private ArrayList<String> shardList;

        private RangeInfo() {
        }
    }
}

