/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.zookeeper.KeeperException;

public class CloudSolrServer
extends SolrServer {
    private volatile ZkStateReader zkStateReader;
    private String zkHost;
    private int zkConnectTimeout = 10000;
    private int zkClientTimeout = 10000;
    private volatile String defaultCollection;
    private LBHttpSolrServer lbServer;
    private HttpClient myClient;
    Random rand = new Random();
    private volatile List<String> urlList;
    private volatile List<String> leaderUrlList;
    private volatile List<String> replicasList;
    private volatile int lastClusterStateHashCode;
    private final boolean updatesToLeaders;

    public CloudSolrServer(String zkHost) throws MalformedURLException {
        this.zkHost = zkHost;
        this.myClient = HttpClientUtil.createClient(null);
        this.lbServer = new LBHttpSolrServer(this.myClient, new String[0]);
        this.updatesToLeaders = true;
    }

    public CloudSolrServer(String zkHost, LBHttpSolrServer lbServer) {
        this.zkHost = zkHost;
        this.lbServer = lbServer;
        this.updatesToLeaders = true;
    }

    public CloudSolrServer(String zkHost, LBHttpSolrServer lbServer, boolean updatesToLeaders) {
        this.zkHost = zkHost;
        this.lbServer = lbServer;
        this.updatesToLeaders = updatesToLeaders;
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    public void setDefaultCollection(String collection) {
        this.defaultCollection = collection;
    }

    public void setZkConnectTimeout(int zkConnectTimeout) {
        this.zkConnectTimeout = zkConnectTimeout;
    }

    public void setZkClientTimeout(int zkClientTimeout) {
        this.zkClientTimeout = zkClientTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        if (this.zkStateReader == null) {
            CloudSolrServer cloudSolrServer = this;
            synchronized (cloudSolrServer) {
                if (this.zkStateReader == null) {
                    try {
                        ZkStateReader zk = new ZkStateReader(this.zkHost, this.zkConnectTimeout, this.zkClientTimeout);
                        zk.createClusterStateWatchersAndUpdate();
                        this.zkStateReader = zk;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                    }
                    catch (KeeperException e) {
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                    }
                    catch (IOException e) {
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                    }
                    catch (TimeoutException e) {
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                    }
                }
            }
        }
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        ArrayList<String> theUrlList;
        String collection;
        SolrParams reqParams;
        this.connect();
        ClusterState clusterState = this.zkStateReader.getClusterState();
        boolean sendToLeaders = false;
        ArrayList<String> replicas = null;
        if (request instanceof IsUpdateRequest && this.updatesToLeaders) {
            sendToLeaders = true;
            replicas = new ArrayList<String>();
        }
        if ((reqParams = request.getParams()) == null) {
            reqParams = new ModifiableSolrParams();
        }
        if ((collection = reqParams.get("collection", this.defaultCollection)) == null) {
            throw new SolrServerException("No collection param specified on request and no default collection has been set.");
        }
        List<String> collectionList = StrUtils.splitSmart(collection, ",", true);
        HashMap<String, Slice> slices = new HashMap<String, Slice>();
        for (int i = 0; i < collectionList.size(); ++i) {
            String coll = collectionList.get(i);
            ClientUtils.appendMap(coll, slices, clusterState.getSlices(coll));
        }
        Set<String> liveNodes = clusterState.getLiveNodes();
        if (sendToLeaders && this.leaderUrlList == null || !sendToLeaders && this.urlList == null || clusterState.hashCode() != this.lastClusterStateHashCode) {
            HashMap<String, Replica> nodes = new HashMap<String, Replica>();
            ArrayList<String> urlList = new ArrayList<String>();
            for (Slice slice : slices.values()) {
                for (Replica nodeProps : slice.getReplicasMap().values()) {
                    String url;
                    ZkCoreNodeProps coreNodeProps = new ZkCoreNodeProps(nodeProps);
                    String node = coreNodeProps.getNodeName();
                    if (!liveNodes.contains(coreNodeProps.getNodeName()) || !coreNodeProps.getState().equals("active") || nodes.put(node, nodeProps) != null) continue;
                    if (!sendToLeaders || sendToLeaders && coreNodeProps.isLeader()) {
                        url = coreNodeProps.getCoreUrl();
                        urlList.add(url);
                        continue;
                    }
                    if (!sendToLeaders) continue;
                    url = coreNodeProps.getCoreUrl();
                    replicas.add(url);
                }
            }
            if (sendToLeaders) {
                this.leaderUrlList = urlList;
                this.replicasList = replicas;
            } else {
                this.urlList = urlList;
            }
            this.lastClusterStateHashCode = clusterState.hashCode();
        }
        if (sendToLeaders) {
            theUrlList = new ArrayList<String>(this.leaderUrlList.size());
            theUrlList.addAll(this.leaderUrlList);
        } else {
            theUrlList = new ArrayList(this.urlList.size());
            theUrlList.addAll(this.urlList);
        }
        Collections.shuffle(theUrlList, this.rand);
        if (sendToLeaders) {
            ArrayList<String> theReplicas = new ArrayList<String>(this.replicasList.size());
            theReplicas.addAll(this.replicasList);
            Collections.shuffle(theReplicas, this.rand);
            theUrlList.addAll(theReplicas);
        }
        LBHttpSolrServer.Req req = new LBHttpSolrServer.Req(request, theUrlList);
        LBHttpSolrServer.Rsp rsp = this.lbServer.request(req);
        return rsp.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.zkStateReader != null) {
            CloudSolrServer cloudSolrServer = this;
            synchronized (cloudSolrServer) {
                if (this.zkStateReader != null) {
                    this.zkStateReader.close();
                }
                this.zkStateReader = null;
            }
        }
        if (this.myClient != null) {
            this.myClient.getConnectionManager().shutdown();
        }
    }

    public LBHttpSolrServer getLbServer() {
        return this.lbServer;
    }

    List<String> getUrlList() {
        return this.urlList;
    }

    List<String> getLeaderUrlList() {
        return this.leaderUrlList;
    }

    List<String> getReplicasList() {
        return this.replicasList;
    }
}

