/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SolrParams
implements Serializable {
    public abstract String get(String var1);

    public abstract String[] getParams(String var1);

    public abstract Iterator<String> getParameterNamesIterator();

    public String get(String param, String def) {
        String val = this.get(param);
        return val == null ? def : val;
    }

    public RequiredSolrParams required() {
        return new RequiredSolrParams(this);
    }

    protected String fpname(String field, String param) {
        return "f." + field + '.' + param;
    }

    public String getFieldParam(String field, String param) {
        String val = this.get(this.fpname(field, param));
        return val != null ? val : this.get(param);
    }

    public String getFieldParam(String field, String param, String def) {
        String val = this.get(this.fpname(field, param));
        return val != null ? val : this.get(param, def);
    }

    public String[] getFieldParams(String field, String param) {
        String[] val = this.getParams(this.fpname(field, param));
        return val != null ? val : this.getParams(param);
    }

    public Boolean getBool(String param) {
        String val = this.get(param);
        return val == null ? null : Boolean.valueOf(StrUtils.parseBool(val));
    }

    public boolean getBool(String param, boolean def) {
        String val = this.get(param);
        return val == null ? def : StrUtils.parseBool(val);
    }

    public Boolean getFieldBool(String field, String param) {
        String val = this.getFieldParam(field, param);
        return val == null ? null : Boolean.valueOf(StrUtils.parseBool(val));
    }

    public boolean getFieldBool(String field, String param, boolean def) {
        String val = this.getFieldParam(field, param);
        return val == null ? def : StrUtils.parseBool(val);
    }

    public Integer getInt(String param) {
        String val = this.get(param);
        try {
            return val == null ? null : Integer.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public int getInt(String param, int def) {
        String val = this.get(param);
        try {
            return val == null ? def : Integer.parseInt(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Integer getFieldInt(String field, String param) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? null : Integer.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public int getFieldInt(String field, String param, int def) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? def : Integer.parseInt(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Float getFloat(String param) {
        String val = this.get(param);
        try {
            return val == null ? null : Float.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public float getFloat(String param, float def) {
        String val = this.get(param);
        try {
            return val == null ? def : Float.parseFloat(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Double getDouble(String param) {
        String val = this.get(param);
        try {
            return val == null ? null : Double.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public double getDouble(String param, double def) {
        String val = this.get(param);
        try {
            return val == null ? def : Double.parseDouble(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Float getFieldFloat(String field, String param) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? null : Float.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public float getFieldFloat(String field, String param, float def) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? def : Float.parseFloat(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Double getFieldDouble(String field, String param) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? null : Double.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public double getFieldDouble(String field, String param, double def) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? def : Double.parseDouble(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    @Deprecated
    protected boolean parseBool(String s) {
        return StrUtils.parseBool(s);
    }

    public static Map<String, String> toMap(NamedList params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < params.size(); ++i) {
            map.put(params.getName(i), params.getVal(i).toString());
        }
        return map;
    }

    public static Map<String, String[]> toMultiMap(NamedList params) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (int i = 0; i < params.size(); ++i) {
            String name = params.getName(i);
            String val = params.getVal(i).toString();
            MultiMapSolrParams.addParam(name, val, map);
        }
        return map;
    }

    public static SolrParams toSolrParams(NamedList params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < params.size(); ++i) {
            String prev = map.put(params.getName(i), params.getVal(i).toString());
            if (prev == null) continue;
            return new MultiMapSolrParams(SolrParams.toMultiMap(params));
        }
        return new MapSolrParams(map);
    }

    public NamedList<Object> toNamedList() {
        SimpleOrderedMap<Object> result = new SimpleOrderedMap<Object>();
        Iterator<String> it = this.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = it.next();
            String[] values = this.getParams(name);
            if (values.length == 1) {
                result.add(name, values[0]);
                continue;
            }
            result.add(name, values);
        }
        return result;
    }
}

