/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.standalone.jdbc;

import com.google.common.base.Strings;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import lombok.Generated;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.jdbc.props.JDBCRepositoryProperties;
import org.apache.shardingsphere.mode.repository.standalone.jdbc.props.JDBCRepositoryPropertyKey;
import org.apache.shardingsphere.mode.repository.standalone.jdbc.sql.JDBCRepositorySQL;
import org.apache.shardingsphere.mode.repository.standalone.jdbc.sql.JDBCRepositorySQLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCRepository
implements StandalonePersistRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCRepository.class);
    private static final String SEPARATOR = "/";
    private JDBCRepositorySQL repositorySQL;
    private HikariDataSource dataSource;

    public void init(Properties props) {
        JDBCRepositoryProperties jdbcRepositoryProps = new JDBCRepositoryProperties(props);
        this.repositorySQL = JDBCRepositorySQLLoader.load((String)jdbcRepositoryProps.getValue(JDBCRepositoryPropertyKey.PROVIDER));
        this.dataSource = new HikariDataSource();
        this.dataSource.setDriverClassName(this.repositorySQL.getDriverClassName());
        this.dataSource.setJdbcUrl((String)jdbcRepositoryProps.getValue(JDBCRepositoryPropertyKey.JDBC_URL));
        this.dataSource.setUsername((String)jdbcRepositoryProps.getValue(JDBCRepositoryPropertyKey.USERNAME));
        this.dataSource.setPassword((String)jdbcRepositoryProps.getValue(JDBCRepositoryPropertyKey.PASSWORD));
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            if (((String)jdbcRepositoryProps.getValue(JDBCRepositoryPropertyKey.JDBC_URL)).contains("h2:mem:")) {
                try {
                    statement.execute("TRUNCATE TABLE `repository`");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            statement.execute(this.repositorySQL.getCreateTableSQL());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDirectly(String key) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.repositorySQL.getSelectByKeySQL());){
            preparedStatement.setString(1, key);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return "";
                String string = resultSet.getString("value");
                return string;
            }
        }
        catch (SQLException ex) {
            log.error("Get {} data by key: {} failed", new Object[]{this.getType(), key, ex});
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    public List<String> getChildrenKeys(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isExisted(String key) {
        return !Strings.isNullOrEmpty((String)this.getDirectly(key));
    }

    public void persist(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.update(key, value);
                return;
            }
            String tempPrefix = "";
            String parent = SEPARATOR;
            String[] paths = (String[])Arrays.stream(key.split(SEPARATOR)).filter(each -> !Strings.isNullOrEmpty((String)each)).toArray(String[]::new);
            for (int i = 0; i < paths.length - 1; ++i) {
                String tempKey = tempPrefix + SEPARATOR + paths[i];
                String tempKeyVal = this.getDirectly(tempKey);
                if (Strings.isNullOrEmpty((String)tempKeyVal)) {
                    this.insert(tempKey, "", parent);
                }
                tempPrefix = tempKey;
                parent = tempKey;
            }
            this.insert(key, value, parent);
        }
        catch (SQLException ex) {
            log.error("Persist {} data to key: {} failed", new Object[]{this.getType(), key, ex});
        }
    }

    private void insert(String key, String value, String parent) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.repositorySQL.getInsertSQL());){
            preparedStatement.setString(1, UUID.randomUUID().toString());
            preparedStatement.setString(2, key);
            preparedStatement.setString(3, value);
            preparedStatement.setString(4, parent);
            preparedStatement.executeUpdate();
        }
    }

    public void update(String key, String value) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.repositorySQL.getUpdateSQL());){
            preparedStatement.setString(1, value);
            preparedStatement.setString(2, key);
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            log.error("Update {} data to key: {} failed", new Object[]{this.getType(), key, ex});
        }
    }

    public void delete(String key) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.repositorySQL.getDeleteSQL());){
            preparedStatement.setString(1, key);
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            log.error("Delete {} data by key: {} failed", new Object[]{this.getType(), key, ex});
        }
    }

    public void close() {
        this.dataSource.close();
    }

    public String getType() {
        return "JDBC";
    }

    public boolean isDefault() {
        return true;
    }
}

