/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

@Internal
class SttbfUtils {
    SttbfUtils() {
    }

    public static String[] read(byte[] data, int startOffset) {
        short ffff = LittleEndian.getShort((byte[])data, (int)startOffset);
        if (ffff != -1) {
            throw new UnsupportedOperationException("Non-extended character Pascal strings are not supported right now. Please, contact POI developers for update.");
        }
        int offset = startOffset + 2;
        int numEntries = LittleEndian.getInt((byte[])data, (int)offset);
        offset += 4;
        String[] entries = new String[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            short len = LittleEndian.getShort((byte[])data, (int)offset);
            String value = StringUtil.getFromUnicodeLE((byte[])data, (int)(offset += 2), (int)len);
            offset += len * 2;
            entries[i] = value;
        }
        return entries;
    }

    public static int write(HWPFOutputStream tableStream, String[] entries) throws IOException {
        byte[] header = new byte[6];
        LittleEndian.putShort((byte[])header, (int)0, (short)-1);
        if (entries == null || entries.length == 0) {
            LittleEndian.putInt((byte[])header, (int)2, (int)0);
            tableStream.write(header);
            return 6;
        }
        LittleEndian.putInt((byte[])header, (int)2, (int)entries.length);
        tableStream.write(header);
        int size = 6;
        for (String entry : entries) {
            byte[] buf = new byte[entry.length() * 2 + 2];
            LittleEndian.putShort((byte[])buf, (int)0, (short)((short)entry.length()));
            StringUtil.putUnicodeLE((String)entry, (byte[])buf, (int)2);
            tableStream.write(buf);
            size += buf.length;
        }
        return size;
    }
}

