/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.url.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLParser;

public class PortalURLImpl
implements PortalURL {
    private String serverURI;
    private String servletPath;
    private String renderPath;
    private String actionWindow;
    private PortalURLParser urlParser;
    private Map windowStates = new HashMap();
    private Map portletModes = new HashMap();
    private Map parameters = new HashMap();

    public PortalURLImpl(String protocol, String hostName, String contextPath, String servletName, PortalURLParser urlParser) {
        this(protocol, hostName, -1, contextPath, servletName, urlParser);
    }

    public PortalURLImpl(String protocol, String hostName, int port, String contextPath, String servletName, PortalURLParser urlParser) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(protocol);
        buffer.append(hostName);
        if (port > 0) {
            buffer.append(":").append(port);
        }
        this.serverURI = buffer.toString();
        buffer = new StringBuffer();
        buffer.append(contextPath);
        buffer.append(servletName);
        this.servletPath = buffer.toString();
        this.urlParser = urlParser;
    }

    private PortalURLImpl() {
    }

    public void setRenderPath(String renderPath) {
        this.renderPath = renderPath;
    }

    public String getRenderPath() {
        return this.renderPath;
    }

    public void addParameter(PortalURLParameter param) {
        this.parameters.put(param.getWindowId() + param.getName(), param);
    }

    public Collection getParameters() {
        return this.parameters.values();
    }

    public void setActionWindow(String actionWindow) {
        this.actionWindow = actionWindow;
    }

    public String getActionWindow() {
        return this.actionWindow;
    }

    public Map getPortletModes() {
        return Collections.unmodifiableMap(this.portletModes);
    }

    public PortletMode getPortletMode(String windowId) {
        PortletMode mode = (PortletMode)this.portletModes.get(windowId);
        if (mode == null) {
            mode = PortletMode.VIEW;
        }
        return mode;
    }

    public void setPortletMode(String windowId, PortletMode portletMode) {
        this.portletModes.put(windowId, portletMode);
    }

    public Map getWindowStates() {
        return Collections.unmodifiableMap(this.windowStates);
    }

    public WindowState getWindowState(String windowId) {
        WindowState state = (WindowState)this.windowStates.get(windowId);
        if (state == null) {
            state = WindowState.NORMAL;
        }
        return state;
    }

    public void setWindowState(String windowId, WindowState windowState) {
        this.windowStates.put(windowId, windowState);
    }

    public void clearParameters(String windowId) {
        Iterator it = this.parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            PortalURLParameter param = (PortalURLParameter)entry.getValue();
            if (!param.getWindowId().equals(windowId)) continue;
            it.remove();
        }
    }

    public String toString() {
        return this.urlParser.toString((PortalURL)this);
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Object clone() {
        PortalURLImpl portalURL = new PortalURLImpl();
        portalURL.serverURI = this.serverURI;
        portalURL.servletPath = this.servletPath;
        portalURL.parameters = new HashMap(this.parameters);
        portalURL.portletModes = new HashMap(this.portletModes);
        portalURL.windowStates = new HashMap(this.windowStates);
        portalURL.renderPath = this.renderPath;
        portalURL.actionWindow = this.actionWindow;
        return portalURL;
    }
}

