/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.descriptors.services.castor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.pluto.descriptors.services.WebAppDescriptorService;
import org.apache.pluto.descriptors.services.castor.AbstractCastorDescriptorService;
import org.apache.pluto.descriptors.servlet.WebAppDD;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;

public class WebAppDescriptorServiceImpl
extends AbstractCastorDescriptorService
implements WebAppDescriptorService {
    public static final String WEB_XML_MAPPING = "castor-web-xml-mapping.xml";

    public WebAppDD read(InputStream in) throws IOException {
        WebAppDD webApp = (WebAppDD)this.readInternal(in);
        return webApp;
    }

    public void write(WebAppDD webApp, OutputStream out) throws IOException {
        this.writeInternal(webApp, out);
    }

    protected String getPublicId() {
        return "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    }

    protected String getDTDUri() {
        return "http://java.sun.com/dtd/web-app_2_3.dtd";
    }

    protected Mapping getCastorMapping() throws IOException, MappingException {
        URL url = this.getClass().getResource(WEB_XML_MAPPING);
        if (url == null) {
            throw new NullPointerException("Configuration Error.  Resource: castor-web-xml-mapping.xml not found.");
        }
        Mapping mapping = new Mapping();
        mapping.loadMapping(url);
        return mapping;
    }

    protected void setCastorMarshallerOptions(Marshaller marshaller, Object beingMarshalled) {
        String servletVersion = ((WebAppDD)beingMarshalled).getServletVersion();
        if ("2.3".equals(servletVersion)) {
            marshaller.setDoctype(this.getPublicId(), this.getDTDUri());
        }
    }
}

