/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.LinkedHashMap;
import java.util.Map;

public final class CFFOperator {
    private static final Map<Integer, String> keyMap = new LinkedHashMap<Integer, String>(52);

    private static void register(int key, String name) {
        keyMap.put(key, name);
    }

    public static String getOperator(int b0) {
        return keyMap.get(CFFOperator.calculateKey(b0));
    }

    public static String getOperator(int b0, int b1) {
        return keyMap.get(CFFOperator.calculateKey(b0, b1));
    }

    private static int calculateKey(int b0) {
        return CFFOperator.calculateKey(b0, 0);
    }

    private static int calculateKey(int b0, int b1) {
        return (b1 << 8) + b0;
    }

    static {
        CFFOperator.register(CFFOperator.calculateKey(0), "version");
        CFFOperator.register(CFFOperator.calculateKey(1), "Notice");
        CFFOperator.register(CFFOperator.calculateKey(12, 0), "Copyright");
        CFFOperator.register(CFFOperator.calculateKey(2), "FullName");
        CFFOperator.register(CFFOperator.calculateKey(3), "FamilyName");
        CFFOperator.register(CFFOperator.calculateKey(4), "Weight");
        CFFOperator.register(CFFOperator.calculateKey(12, 1), "isFixedPitch");
        CFFOperator.register(CFFOperator.calculateKey(12, 2), "ItalicAngle");
        CFFOperator.register(CFFOperator.calculateKey(12, 3), "UnderlinePosition");
        CFFOperator.register(CFFOperator.calculateKey(12, 4), "UnderlineThickness");
        CFFOperator.register(CFFOperator.calculateKey(12, 5), "PaintType");
        CFFOperator.register(CFFOperator.calculateKey(12, 6), "CharstringType");
        CFFOperator.register(CFFOperator.calculateKey(12, 7), "FontMatrix");
        CFFOperator.register(CFFOperator.calculateKey(13), "UniqueID");
        CFFOperator.register(CFFOperator.calculateKey(5), "FontBBox");
        CFFOperator.register(CFFOperator.calculateKey(12, 8), "StrokeWidth");
        CFFOperator.register(CFFOperator.calculateKey(14), "XUID");
        CFFOperator.register(CFFOperator.calculateKey(15), "charset");
        CFFOperator.register(CFFOperator.calculateKey(16), "Encoding");
        CFFOperator.register(CFFOperator.calculateKey(17), "CharStrings");
        CFFOperator.register(CFFOperator.calculateKey(18), "Private");
        CFFOperator.register(CFFOperator.calculateKey(12, 20), "SyntheticBase");
        CFFOperator.register(CFFOperator.calculateKey(12, 21), "PostScript");
        CFFOperator.register(CFFOperator.calculateKey(12, 22), "BaseFontName");
        CFFOperator.register(CFFOperator.calculateKey(12, 23), "BaseFontBlend");
        CFFOperator.register(CFFOperator.calculateKey(12, 30), "ROS");
        CFFOperator.register(CFFOperator.calculateKey(12, 31), "CIDFontVersion");
        CFFOperator.register(CFFOperator.calculateKey(12, 32), "CIDFontRevision");
        CFFOperator.register(CFFOperator.calculateKey(12, 33), "CIDFontType");
        CFFOperator.register(CFFOperator.calculateKey(12, 34), "CIDCount");
        CFFOperator.register(CFFOperator.calculateKey(12, 35), "UIDBase");
        CFFOperator.register(CFFOperator.calculateKey(12, 36), "FDArray");
        CFFOperator.register(CFFOperator.calculateKey(12, 37), "FDSelect");
        CFFOperator.register(CFFOperator.calculateKey(12, 38), "FontName");
        CFFOperator.register(CFFOperator.calculateKey(6), "BlueValues");
        CFFOperator.register(CFFOperator.calculateKey(7), "OtherBlues");
        CFFOperator.register(CFFOperator.calculateKey(8), "FamilyBlues");
        CFFOperator.register(CFFOperator.calculateKey(9), "FamilyOtherBlues");
        CFFOperator.register(CFFOperator.calculateKey(12, 9), "BlueScale");
        CFFOperator.register(CFFOperator.calculateKey(12, 10), "BlueShift");
        CFFOperator.register(CFFOperator.calculateKey(12, 11), "BlueFuzz");
        CFFOperator.register(CFFOperator.calculateKey(10), "StdHW");
        CFFOperator.register(CFFOperator.calculateKey(11), "StdVW");
        CFFOperator.register(CFFOperator.calculateKey(12, 12), "StemSnapH");
        CFFOperator.register(CFFOperator.calculateKey(12, 13), "StemSnapV");
        CFFOperator.register(CFFOperator.calculateKey(12, 14), "ForceBold");
        CFFOperator.register(CFFOperator.calculateKey(12, 15), "LanguageGroup");
        CFFOperator.register(CFFOperator.calculateKey(12, 16), "ExpansionFactor");
        CFFOperator.register(CFFOperator.calculateKey(12, 17), "initialRandomSeed");
        CFFOperator.register(CFFOperator.calculateKey(19), "Subrs");
        CFFOperator.register(CFFOperator.calculateKey(20), "defaultWidthX");
        CFFOperator.register(CFFOperator.calculateKey(21), "nominalWidthX");
    }
}

