/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.helper.ViolationMessageBuilder;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.util.InjectionExceptionUtil;
import org.apache.webbeans.util.SecurityUtil;

public class DeploymentValidationService {
    private WebBeansContext webBeansContext;
    private Set<String> allowProxyingClasses;

    public DeploymentValidationService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public UnproxyableResolutionException validateProxyable(OwbBean<?> bean, boolean ignoreFinalMethods) {
        if (this.allowProxyingClasses == null) {
            this.allowProxyingClasses = this.webBeansContext.getOpenWebBeansConfiguration().getConfigListValues("javax.enterprise.inject.allowProxying.classes");
        }
        if (this.webBeansContext.getBeanManagerImpl().isNormalScope(bean.getScope())) {
            ViolationMessageBuilder violationMessage = ViolationMessageBuilder.newViolation();
            Class<?> beanClass = bean.getReturnType();
            if (!beanClass.isInterface() && beanClass != Object.class) {
                if (beanClass.isPrimitive()) {
                    violationMessage.addLine("It isn't possible to proxy a primitive type (" + beanClass.getName(), ")");
                }
                if (beanClass.isArray()) {
                    violationMessage.addLine("It isn't possible to proxy an array type (", beanClass.getName(), ")");
                }
                if (!violationMessage.containsViolation()) {
                    Constructor<?> cons;
                    String finalMethodName;
                    if (Modifier.isFinal(beanClass.getModifiers())) {
                        violationMessage.addLine(beanClass.getName(), " is a final class! CDI doesn't allow to proxy that.");
                    }
                    if (!ignoreFinalMethods && (finalMethodName = this.hasNonPrivateFinalMethod(beanClass)) != null) {
                        if (this.allowProxyingClasses.contains(beanClass.getName())) {
                            WebBeansLoggerFacade.getLogger(DeploymentValidationService.class).info(beanClass.getName() + " has final method " + finalMethodName + ". CDI doesn't allow to proxy that. Continuing because the class is explicitly configured to be treated as proxyable. Final methods shall not get invoked on this proxy!");
                        } else {
                            violationMessage.addLine(beanClass.getName(), " has final method " + finalMethodName + " CDI doesn't allow to proxy that.");
                        }
                    }
                    if ((cons = this.webBeansContext.getWebBeansUtil().getNoArgConstructor(beanClass)) == null) {
                        violationMessage.addLine(beanClass.getName(), " has no explicit no-arg constructor!", "A public or protected constructor without args is required!");
                    } else if (Modifier.isPrivate(cons.getModifiers())) {
                        boolean containsViolation = violationMessage.containsViolation();
                        violationMessage.addLine(beanClass.getName(), " has a >private< no-arg constructor! CDI doesn't allow to proxy that.");
                        if (!containsViolation) {
                            return InjectionExceptionUtil.createUnproxyableResolutionException(violationMessage);
                        }
                    }
                }
                if (violationMessage.containsViolation()) {
                    return InjectionExceptionUtil.createUnproxyableResolutionException(violationMessage);
                }
            }
        }
        return null;
    }

    private String hasNonPrivateFinalMethod(Class<?> beanClass) {
        Method[] methods;
        if (beanClass == Object.class) {
            return null;
        }
        String finalMethodName = this.hasNonPrivateFinalMethod(beanClass.getSuperclass());
        if (finalMethodName != null) {
            return finalMethodName;
        }
        for (Method m : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(beanClass)) {
            int modifiers = m.getModifiers();
            if (!Modifier.isFinal(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || m.isSynthetic() || m.isBridge()) continue;
            return m.getName();
        }
        return null;
    }

    public <T> void validatePassivationCapable(OwbBean<T> bean) {
        if (this.isPassivationCapable(bean)) {
            if (EnterpriseBeanMarker.class.isInstance(bean)) {
                this.validatePassivationCapableDependencies(bean, bean.getInjectionPoints());
                if (BeanInterceptorInfoProvider.class.isInstance(bean)) {
                    this.validatePassivationCapableInterceptorInfo(bean, ((BeanInterceptorInfoProvider)BeanInterceptorInfoProvider.class.cast(bean)).interceptorInfo());
                }
                return;
            }
            if (!(bean instanceof ProducerMethodBean)) {
                this.validatePassivationCapableDependencies(bean, bean.getInjectionPoints());
            }
            if (bean.getProducer() instanceof InjectionTargetImpl) {
                InjectionTargetImpl injectionTarget = (InjectionTargetImpl)bean.getProducer();
                InterceptorResolutionService.BeanInterceptorInfo interceptorInfo = injectionTarget.getInterceptorInfo();
                this.validatePassivationCapableInterceptorInfo(bean, interceptorInfo);
            }
        }
    }

    private <T> void validatePassivationCapableInterceptorInfo(OwbBean<T> bean, InterceptorResolutionService.BeanInterceptorInfo interceptorInfo) {
        if (interceptorInfo != null) {
            for (Interceptor interceptor : interceptorInfo.getEjbInterceptors()) {
                this.validatePassivationCapableDependency(bean, (Bean<?>)interceptor);
            }
            for (Interceptor interceptor : interceptorInfo.getCdiInterceptors()) {
                this.validatePassivationCapableDependency(bean, (Bean<?>)interceptor);
            }
            for (Decorator decorator : interceptorInfo.getDecorators()) {
                this.validatePassivationCapableDependency(bean, (Bean<?>)decorator);
            }
        }
    }

    private <T> void validatePassivationCapableDependency(Bean<T> bean, Bean<?> dependentBean) {
        if (!this.isPassivationCapable(dependentBean)) {
            String type = dependentBean instanceof Interceptor ? "Interceptor " : "Decorator ";
            throw new WebBeansDeploymentException("Passivation capable beans must satisfy passivation capable dependencies. Bean : " + bean.toString() + " does not satisfy. " + type + dependentBean.toString() + " is not passivation capable");
        }
        this.validatePassivationCapableDependencies(bean, dependentBean.getInjectionPoints());
    }

    private <T> void validatePassivationCapableDependencies(Bean<T> bean, Set<InjectionPoint> injectionPoints) {
        for (InjectionPoint injectionPoint : injectionPoints) {
            Annotated annotated;
            if (injectionPoint.isTransient() || this.webBeansContext.getWebBeansUtil().isPassivationCapableDependency(injectionPoint) || (annotated = injectionPoint.getAnnotated()).isAnnotationPresent(Disposes.class) || annotated.isAnnotationPresent(TransientReference.class)) continue;
            throw new WebBeansDeploymentException("Passivation capable beans must satisfy passivation capable dependencies. Bean : " + bean.toString() + " does not satisfy. Details about the Injection-point: " + injectionPoint.toString());
        }
    }

    private boolean isPassivationCapable(Bean<?> bean) {
        return bean instanceof OwbBean ? ((OwbBean)bean).isPassivationCapable() : bean instanceof PassivationCapable;
    }

    public static interface BeanInterceptorInfoProvider {
        public InterceptorResolutionService.BeanInterceptorInfo interceptorInfo();
    }
}

