/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.treeinsert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.parser.AbstractParserEventStream;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParseSampleStream;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.treeinsert.AttachContextGenerator;
import opennlp.tools.parser.treeinsert.BuildContextGenerator;
import opennlp.tools.parser.treeinsert.CheckContextGenerator;
import opennlp.tools.parser.treeinsert.Parser;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

public class ParserEventStream
extends AbstractParserEventStream {
    protected AttachContextGenerator attachContextGenerator;
    protected BuildContextGenerator buildContextGenerator;
    protected CheckContextGenerator checkContextGenerator;
    private static final boolean debug = false;

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype, Dictionary dict) {
        super(d, rules, etype, dict);
    }

    @Override
    public void init() {
        this.buildContextGenerator = new BuildContextGenerator();
        this.attachContextGenerator = new AttachContextGenerator(this.punctSet);
        this.checkContextGenerator = new CheckContextGenerator(this.punctSet);
    }

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype) {
        super(d, rules, etype);
    }

    private Map<Parse, Integer> getNonAdjoinedParent(Parse node) {
        HashMap<Parse, Integer> parents = new HashMap<Parse, Integer>();
        Parse parent = node.getParent();
        int index = this.indexOf(node, parent);
        parents.put(parent, index);
        while (parent.getType().equals(node.getType())) {
            node = parent;
            parent = parent.getParent();
            index = this.indexOf(node, parent);
            parents.put(parent, index);
        }
        return parents;
    }

    private int indexOf(Parse child, Parse parent) {
        Parse[] kids = Parser.collapsePunctuation(parent.getChildren(), this.punctSet);
        for (int ki = 0; ki < kids.length; ++ki) {
            if (child != kids[ki]) continue;
            return ki;
        }
        return -1;
    }

    private int nonPunctChildCount(Parse node) {
        return Parser.collapsePunctuation(node.getChildren(), this.punctSet).length;
    }

    @Override
    protected boolean lastChild(Parse child, Parse parent) {
        Parse cp;
        boolean lc = super.lastChild(child, parent);
        while (!lc && (cp = child.getParent()) != parent && cp.getType().equals(child.getType())) {
            lc = super.lastChild(cp, parent);
            child = cp;
        }
        return lc;
    }

    @Override
    protected void addParseEvents(List<Event> parseEvents, Parse[] chunks) {
        int ci;
        ArrayList<Parse> rightFrontier = new ArrayList<Parse>();
        ArrayList<Parse> builtNodes = new ArrayList<Parse>();
        Parse[] currentChunks = new Parse[chunks.length];
        for (ci = 0; ci < chunks.length; ++ci) {
            currentChunks[ci] = (Parse)chunks[ci].clone();
            currentChunks[ci].setPrevPunctuation(chunks[ci].getPreviousPunctuationSet());
            currentChunks[ci].setNextPunctuation(chunks[ci].getNextPunctuationSet());
            currentChunks[ci].setLabel("c");
            chunks[ci].setLabel("c");
        }
        for (ci = 0; ci < chunks.length; ++ci) {
            Parse parent = chunks[ci].getParent();
            Parse prevParent = chunks[ci];
            int off = 0;
            if (!chunks[ci].isPosTag()) {
                builtNodes.add(off++, chunks[ci]);
            }
            while (!parent.getType().equals("TOP") && parent.getLabel() == null) {
                if (parent.getLabel() == null && !prevParent.getType().equals(parent.getType())) {
                    if (this.etype == ParserEventTypeEnum.BUILD) {
                        parseEvents.add(new Event(parent.getType(), this.buildContextGenerator.getContext(currentChunks, ci)));
                    }
                    builtNodes.add(off++, parent);
                    Parse newParent = new Parse(currentChunks[ci].getText(), currentChunks[ci].getSpan(), parent.getType(), 1.0, 0);
                    newParent.add(currentChunks[ci], this.rules);
                    newParent.setPrevPunctuation(currentChunks[ci].getPreviousPunctuationSet());
                    newParent.setNextPunctuation(currentChunks[ci].getNextPunctuationSet());
                    currentChunks[ci].setParent(newParent);
                    currentChunks[ci] = newParent;
                    newParent.setLabel("built");
                    if (this.lastChild(chunks[ci], parent)) {
                        if (this.etype == ParserEventTypeEnum.CHECK) {
                            parseEvents.add(new Event("c", this.checkContextGenerator.getContext(currentChunks[ci], currentChunks, ci, false)));
                        }
                        currentChunks[ci].setLabel("c");
                        parent.setLabel("c");
                    } else {
                        if (this.etype == ParserEventTypeEnum.CHECK) {
                            parseEvents.add(new Event("i", this.checkContextGenerator.getContext(currentChunks[ci], currentChunks, ci, false)));
                        }
                        currentChunks[ci].setLabel("i");
                        parent.setLabel("c");
                    }
                    chunks[ci] = parent;
                }
                parent.setLabel("built");
                prevParent = parent;
                parent = parent.getParent();
            }
            if (this.etype == ParserEventTypeEnum.BUILD) {
                parseEvents.add(new Event("d", this.buildContextGenerator.getContext(currentChunks, ci)));
            }
            String attachType = null;
            Parse attachNode = null;
            int attachNodeIndex = -1;
            if (ci == 0) {
                Parse top = new Parse(currentChunks[ci].getText(), new Span(0, currentChunks[ci].getText().length()), "TOP", 1.0, 0);
                top.insert(currentChunks[ci]);
            } else {
                Parse cfn;
                Parse frontierNode;
                int cfi;
                List<Parse> currentRightFrontier = Parser.getRightFrontier(currentChunks[0], this.punctSet);
                if (currentRightFrontier.size() != rightFrontier.size()) {
                    System.err.println("fontiers mis-aligned: " + currentRightFrontier.size() + " != " + rightFrontier.size() + " " + currentRightFrontier + " " + rightFrontier);
                    System.exit(1);
                }
                Map<Parse, Integer> parents = this.getNonAdjoinedParent(chunks[ci]);
                for (cfi = 0; cfi < currentRightFrontier.size(); ++cfi) {
                    frontierNode = (Parse)rightFrontier.get(cfi);
                    cfn = currentRightFrontier.get(cfi);
                    if (!Parser.checkComplete || !"c".equals(cfn.getLabel())) {
                        Integer i = parents.get(frontierNode);
                        if (attachNode == null && i != null && i.intValue() == this.nonPunctChildCount(cfn)) {
                            attachType = "d";
                            attachNodeIndex = cfi;
                            attachNode = cfn;
                            if (this.etype == ParserEventTypeEnum.ATTACH) {
                                parseEvents.add(new Event(attachType, this.attachContextGenerator.getContext(currentChunks, ci, currentRightFrontier, attachNodeIndex)));
                            }
                        }
                    }
                    if (Parser.checkComplete && cfn.getLabel().equals("i")) break;
                }
                for (cfi = 0; cfi < currentRightFrontier.size(); ++cfi) {
                    frontierNode = (Parse)rightFrontier.get(cfi);
                    cfn = currentRightFrontier.get(cfi);
                    if (attachNode == null && parents.containsKey(frontierNode.getParent()) && frontierNode.getType().equals(frontierNode.getParent().getType())) {
                        attachType = "s";
                        attachNode = cfn;
                        attachNodeIndex = cfi;
                        if (this.etype == ParserEventTypeEnum.ATTACH) {
                            parseEvents.add(new Event("s", this.attachContextGenerator.getContext(currentChunks, ci, currentRightFrontier, cfi)));
                        }
                        chunks[ci].getParent().setLabel("built");
                    } else if (cfi != attachNodeIndex && this.etype == ParserEventTypeEnum.ATTACH) {
                        parseEvents.add(new Event("n", this.attachContextGenerator.getContext(currentChunks, ci, currentRightFrontier, cfi)));
                    }
                    if (Parser.checkComplete && cfn.getLabel().equals("i")) break;
                }
                if (attachNode != null) {
                    if ("d".equals(attachType)) {
                        Parse daughter = currentChunks[ci];
                        attachNode.add(daughter, this.rules);
                        daughter.setParent(attachNode);
                        if (this.lastChild(chunks[ci], (Parse)rightFrontier.get(attachNodeIndex))) {
                            if (this.etype == ParserEventTypeEnum.CHECK) {
                                parseEvents.add(new Event("c", this.checkContextGenerator.getContext(attachNode, currentChunks, ci, true)));
                            }
                            attachNode.setLabel("c");
                        } else if (this.etype == ParserEventTypeEnum.CHECK) {
                            parseEvents.add(new Event("i", this.checkContextGenerator.getContext(attachNode, currentChunks, ci, true)));
                        }
                    } else if ("s".equals(attachType)) {
                        Parse frontierNode2 = (Parse)rightFrontier.get(attachNodeIndex);
                        rightFrontier.set(attachNodeIndex, frontierNode2.getParent());
                        Parse sister = currentChunks[ci];
                        Parse newParent = attachNode.getParent().adjoin(sister, this.rules);
                        newParent.setParent(attachNode.getParent());
                        attachNode.setParent(newParent);
                        sister.setParent(newParent);
                        if (attachNode == currentChunks[0]) {
                            currentChunks[0] = newParent;
                        }
                        if (this.lastChild(chunks[ci], (Parse)rightFrontier.get(attachNodeIndex))) {
                            if (this.etype == ParserEventTypeEnum.CHECK) {
                                parseEvents.add(new Event("c", this.checkContextGenerator.getContext(newParent, currentChunks, ci, true)));
                            }
                            newParent.setLabel("c");
                        } else {
                            if (this.etype == ParserEventTypeEnum.CHECK) {
                                parseEvents.add(new Event("i", this.checkContextGenerator.getContext(newParent, currentChunks, ci, true)));
                            }
                            newParent.setLabel("i");
                        }
                    }
                    for (int ni = 0; ni < attachNodeIndex; ++ni) {
                        rightFrontier.remove(0);
                    }
                } else {
                    throw new RuntimeException("No Attachment: " + chunks[ci]);
                }
            }
            rightFrontier.addAll(0, builtNodes);
            builtNodes.clear();
        }
    }

    public static void main(String[] args) throws IOException {
        int ai;
        if (args.length == 0) {
            System.err.println("Usage ParserEventStream -[tag|chunk|build|attach] [-fun] [-dict dictionary] [-model model] head_rules < parses");
            System.exit(1);
        }
        ParserEventTypeEnum etype = null;
        boolean fun = false;
        Dictionary dict = null;
        AbstractModel model = null;
        block29: for (ai = 0; ai < args.length && args[ai].startsWith("-"); ++ai) {
            switch (args[ai]) {
                case "-build": {
                    etype = ParserEventTypeEnum.BUILD;
                    continue block29;
                }
                case "-attach": {
                    etype = ParserEventTypeEnum.ATTACH;
                    continue block29;
                }
                case "-chunk": {
                    etype = ParserEventTypeEnum.CHUNK;
                    continue block29;
                }
                case "-check": {
                    etype = ParserEventTypeEnum.CHECK;
                    continue block29;
                }
                case "-tag": {
                    etype = ParserEventTypeEnum.TAG;
                    continue block29;
                }
                case "-fun": {
                    fun = true;
                    continue block29;
                }
                case "-dict": {
                    dict = new Dictionary(new FileInputStream(args[++ai]));
                    continue block29;
                }
                case "-model": {
                    model = new SuffixSensitiveGISModelReader(new File(args[++ai])).getModel();
                    continue block29;
                }
                default: {
                    System.err.println("Invalid option " + args[ai]);
                    System.exit(1);
                }
            }
        }
        opennlp.tools.parser.lang.en.HeadRules rules = new opennlp.tools.parser.lang.en.HeadRules(args[ai++]);
        if (fun) {
            Parse.useFunctionTags(true);
        }
        try (ParserEventStream es = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), Charset.defaultCharset())), rules, etype, dict);){
            Event e;
            while ((e = (Event)es.read()) != null) {
                if (model != null) {
                    System.out.print(model.eval(e.getContext())[model.getIndex(e.getOutcome())] + " ");
                }
                System.out.println(e);
            }
        }
    }
}

