/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cli;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.cli.Main;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.openejb.util.OptionsLog;
import org.apache.xbean.finder.ResourceFinder;

public class MainImpl
implements Main {
    private static final String BASE_PATH = "META-INF/org.apache.openejb.cli/";
    private static final String MAIN_CLASS_PROPERTY_NAME = "main.class";
    private static ResourceFinder finder = null;
    private static String locale = "";
    private static String descriptionBase = "description";
    private static String descriptionI18n;

    @Override
    public void main(String[] args) {
        String mainClass;
        args = this.processSystemProperties(args);
        finder = new ResourceFinder(BASE_PATH);
        locale = Locale.getDefault().getLanguage();
        descriptionI18n = descriptionBase + "." + locale;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption(null, "version", false, "");
        options.addOption("h", "help", false, "");
        options.addOption("e", "errors", false, "Produce execution error messages");
        CommandLine line = null;
        String commandName = null;
        try {
            line = parser.parse(options, args, true);
            List list = line.getArgList();
            if (list.size() > 0) {
                commandName = (String)list.get(0);
                list.remove(0);
            }
            args = line.getArgs();
        }
        catch (ParseException exp) {
            exp.printStackTrace();
            System.exit(-1);
        }
        if (line.hasOption("version")) {
            OpenEjbVersion.get().print(System.out);
            System.exit(0);
        } else if (line.hasOption("help") || commandName == null || commandName.equals("help")) {
            MainImpl.help();
            System.exit(0);
        }
        Properties props = null;
        try {
            props = finder.findProperties(commandName);
        }
        catch (IOException e1) {
            System.out.println("Unavailable command: " + commandName);
            MainImpl.help(false);
            System.exit(1);
        }
        if (props == null) {
            System.out.println("Unavailable command: " + commandName);
            MainImpl.help(false);
            System.exit(1);
        }
        if ((mainClass = props.getProperty(MAIN_CLASS_PROPERTY_NAME)) == null) {
            throw new NullPointerException("Command " + commandName + " did not specify a " + MAIN_CLASS_PROPERTY_NAME + " property");
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(mainClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Main class of command " + commandName + " does not exist: " + mainClass, cnfe);
        }
        Method mainMethod = null;
        try {
            mainMethod = clazz.getMethod("main", String[].class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Main class of command " + commandName + " does not have a static main method: " + mainClass, e);
        }
        try {
            mainMethod.invoke(clazz, new Object[]{args});
        }
        catch (Throwable e) {
            if (line.hasOption("errors")) {
                e.printStackTrace();
            }
            System.exit(-10);
        }
    }

    private String[] processSystemProperties(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        for (String arg : args) {
            if (arg.indexOf("-Dopenejb.base") == -1) continue;
            String prop = arg.substring(arg.indexOf("-D") + 2, arg.indexOf("="));
            String val = arg.substring(arg.indexOf("=") + 1);
            System.setProperty(prop, val);
        }
        SystemInstance systemInstance = null;
        try {
            SystemInstance.init(System.getProperties());
            OptionsLog.install();
            systemInstance = SystemInstance.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
        try {
            File conf = systemInstance.getBase().getDirectory("conf");
            File file = new File(conf, "system.properties");
            if (file.exists()) {
                Properties systemProperties = new Properties();
                FileInputStream fin = new FileInputStream(file);
                BufferedInputStream in = new BufferedInputStream(fin);
                systemProperties.load(in);
                System.getProperties().putAll((Map<?, ?>)systemProperties);
                systemInstance.getProperties().putAll((Map<?, ?>)systemProperties);
            }
        }
        catch (IOException e) {
            System.out.println("Processing conf/system.properties failed: " + e.getMessage());
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.indexOf("-D") != -1) {
                String prop = arg.substring(arg.indexOf("-D") + 2, arg.indexOf("="));
                String val = arg.substring(arg.indexOf("=") + 1);
                System.setProperty(prop, val);
                systemInstance.setProperty(prop, val);
                continue;
            }
            argsList.add(arg);
        }
        args = argsList.toArray(new String[argsList.size()]);
        return args;
    }

    public static Enumeration<URL> doFindCommands() throws IOException {
        return Thread.currentThread().getContextClassLoader().getResources(BASE_PATH);
    }

    private static void help() {
        MainImpl.help(true);
    }

    private static void help(boolean printHeader) {
        try {
            Options options = new Options();
            ResourceFinder commandFinder = new ResourceFinder("META-INF");
            Map<String, Properties> commands = commandFinder.mapAvailableProperties("org.apache.openejb.cli");
            for (Map.Entry<String, Properties> command : commands.entrySet()) {
                if (command.getKey().contains(".")) continue;
                Properties p = command.getValue();
                String description = p.getProperty(descriptionI18n, p.getProperty(descriptionBase));
                options.addOption(command.getKey(), false, description);
            }
            HelpFormatter formatter = new HelpFormatter();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            String syntax = "openejb <command> [options] [args]";
            String header = "\nAvailable commands:";
            String footer = "\nTry 'openejb <command> --help' for help on a specific command.\nFor example 'openejb deploy --help'.\n\nApache OpenEJB -- EJB Container System and Server.\nFor additional information, see http://openejb.apache.org\nBug Reports to <users@openejb.apache.org>";
            if (!printHeader) {
                pw.append(header).append("\n\n");
                formatter.printOptions(pw, 74, options, 1, 3);
            } else {
                formatter.printHelp(pw, 74, syntax, header, options, 1, 3, footer, false);
            }
            pw.flush();
            String text = sw.toString().replaceAll("\n -", "\n  ");
            text = text.replace("\nApache OpenEJB", "\n\nApache OpenEJB");
            System.out.print(text);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

