/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.InterceptorInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodInfoUtil;
import org.apache.openejb.assembler.classic.MethodInterceptorInfo;
import org.apache.openejb.core.interceptor.InterceptorData;

public class InterceptorBuilder {
    public final List<InterceptorData> defaultInterceptors;
    public final boolean excludeDefaultInterceptors;
    public final List<InterceptorData> classInterceptors;
    public final List<MethodInterceptorInfo> methodInterceptors;
    public static final MethodInterceptorInfoComparator METHOD_INTERCEPTOR_INFO_COMPARATOR = new MethodInterceptorInfoComparator();

    public InterceptorBuilder(List<InterceptorInfo> defaultInterceptors, EnterpriseBeanInfo bean) {
        this.defaultInterceptors = InterceptorBuilder.toInterceptorDatas(defaultInterceptors);
        this.excludeDefaultInterceptors = false;
        this.classInterceptors = null;
        this.methodInterceptors = null;
        Collections.sort(this.methodInterceptors, METHOD_INTERCEPTOR_INFO_COMPARATOR);
    }

    public List<InterceptorData> build(Method method) {
        ArrayList<InterceptorData> interceptors = new ArrayList<InterceptorData>();
        for (MethodInterceptorInfo methodInterceptorInfo : this.methodInterceptors) {
            if (!MethodInfoUtil.matches(method, methodInterceptorInfo.methodInfo)) continue;
            if (!methodInterceptorInfo.excludeDefaultInterceptors) {
                for (InterceptorData interceptorData : this.defaultInterceptors) {
                    interceptors.add(interceptorData);
                }
            }
            if (!methodInterceptorInfo.excludeClassInterceptors) {
                for (InterceptorData interceptorData : this.classInterceptors) {
                    interceptors.add(interceptorData);
                }
            }
            return interceptors;
        }
        if (!this.excludeDefaultInterceptors) {
            for (InterceptorData interceptorData : this.defaultInterceptors) {
                interceptors.add(interceptorData);
            }
        }
        for (InterceptorData interceptorData : this.classInterceptors) {
            interceptors.add(interceptorData);
        }
        return interceptors;
    }

    private static List<InterceptorData> toInterceptorDatas(List<InterceptorInfo> interceptorInfos) {
        ArrayList<InterceptorData> interceptorDatas = new ArrayList<InterceptorData>(interceptorInfos.size());
        return interceptorDatas;
    }

    public static class MethodInterceptorInfoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            MethodInterceptorInfo mi1 = (MethodInterceptorInfo)o1;
            MethodInterceptorInfo mi2 = (MethodInterceptorInfo)o2;
            MethodInfo m1 = mi1.methodInfo;
            MethodInfo m2 = mi2.methodInfo;
            int val = m1.methodName.compareTo(m2.methodName);
            if (val != 0) {
                return val;
            }
            if (m1.methodParams == null) {
                return m2.methodParams == null ? 0 : -1;
            }
            if (m2.methodParams == null) {
                return 1;
            }
            if (m1.methodParams.size() != m2.methodParams.size()) {
                return m1.methodParams.size() - m2.methodParams.size();
            }
            Iterator<String> iterator = m1.methodParams.iterator();
            for (String param2 : m2.methodParams) {
                String param1 = iterator.next();
                val = param1.compareTo(param2);
                if (val == 0) continue;
                return val;
            }
            return 0;
        }
    }
}

