/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.maven.plugin;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.myfaces.maven.plugin.AbstractAPTMojo;
import org.apache.myfaces.maven.plugin.AllSourcesInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public class TestAptMojo
extends AbstractAPTMojo {
    private String testGenerated;
    private boolean skip;
    private List compileSourceRoots;
    private List aptSourceRoots;
    private List testClasspathElements;
    private File outputDirectory;
    private Set testIncludes = new HashSet();
    private Set testExcludes = new HashSet();

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        super.execute();
        File absoluteGeneratedPath = new File(this.getProject().getBasedir(), this.getGenerated());
        this.getProject().addTestCompileSourceRoot(absoluteGeneratedPath.getPath());
        Resource resource = new Resource();
        resource.setFiltering(this.isResourceFiltering());
        if (this.getResourceTargetPath() != null) {
            resource.setTargetPath(this.getResourceTargetPath());
        }
        resource.setDirectory(absoluteGeneratedPath.getPath());
        resource.addExclude("**/*.java");
        this.getProject().addTestResource(resource);
    }

    protected String getGenerated() {
        return this.testGenerated;
    }

    protected List getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    protected List getClasspathElements() {
        return this.testClasspathElements;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected List getAptSourceRoots() {
        return this.aptSourceRoots;
    }

    protected SourceInclusionScanner getSourceInclusionScanner() {
        StaleSourceScanner scanner = null;
        if (this.testIncludes.isEmpty()) {
            this.testIncludes.add("**/*.java");
        }
        if (this.isForce()) {
            return new AllSourcesInclusionScanner(this.testIncludes, this.testExcludes);
        }
        scanner = new StaleSourceScanner((long)this.getStaleMillis(), this.testIncludes, this.testExcludes);
        if (this.getTargetFiles() != null && this.getTargetFiles().size() > 0) {
            for (String file : this.getTargetFiles()) {
                scanner.addSourceMapping((SourceMapping)new SingleTargetSourceMapping(".java", file));
            }
        } else {
            scanner.addSourceMapping((SourceMapping)new SuffixMapping(".java", ".class"));
        }
        return scanner;
    }
}

