/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng.conf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.testng.TestNG;

public abstract class AbstractDirectConfigurator
implements Configurator {
    protected final Map setters;
    static /* synthetic */ Class class$java$lang$Integer;

    protected AbstractDirectConfigurator() {
        HashMap<String, Setter> options = new HashMap<String, Setter>();
        options.put("groups", new Setter("setGroups", String.class));
        options.put("excludedgroups", new Setter("setExcludedGroups", String.class));
        options.put("junit", new Setter("setJUnit", Boolean.class));
        options.put("threadcount", new Setter("setThreadCount", Integer.TYPE));
        options.put("usedefaultlisteners", new Setter("setUseDefaultListeners", Boolean.TYPE));
        this.setters = options;
    }

    public void configure(TestNG testng, Map options) throws TestSetFailedException {
        String listeners = (String)options.remove("listener");
        testng.setUseDefaultListeners(false);
        Iterator it = options.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            Setter setter = (Setter)this.setters.get(key);
            if (setter == null) continue;
            try {
                setter.invoke(testng, val);
            }
            catch (Exception ex) {
                throw new NestedRuntimeException("Cannot set option " + key + " with value " + val, (Throwable)ex);
            }
        }
        testng.setListenerClasses(AbstractDirectConfigurator.loadListenerClasses(listeners));
    }

    public static List loadListenerClasses(String listenerClasses) throws TestSetFailedException {
        if (listenerClasses == null || "".equals(listenerClasses.trim())) {
            return new ArrayList();
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        String[] classNames = listenerClasses.split(" *, *");
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            Class clazz = AbstractDirectConfigurator.loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    public static Class loadClass(String className) throws TestSetFailedException {
        try {
            return Class.forName(className);
        }
        catch (Exception ex) {
            throw new TestSetFailedException("Cannot find listener class " + className, (Throwable)ex);
        }
    }

    public static final class Setter {
        private final String setterName;
        private final Class paramClass;

        public Setter(String name, Class clazz) {
            this.setterName = name;
            this.paramClass = clazz;
        }

        public void invoke(Object target, Object value) throws Exception {
            Method setter = target.getClass().getMethod(this.setterName, this.paramClass);
            if (setter != null) {
                setter.invoke(target, this.convertValue(value));
            }
        }

        protected Object convertValue(Object value) {
            if (value == null) {
                return value;
            }
            if (this.paramClass.isAssignableFrom(value.getClass())) {
                return value;
            }
            if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractDirectConfigurator.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(this.paramClass) || Boolean.TYPE.equals(this.paramClass)) {
                return Boolean.valueOf(value.toString());
            }
            if ((class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractDirectConfigurator.class$("java.lang.Integer")) : class$java$lang$Integer).equals(this.paramClass) || Integer.TYPE.equals(this.paramClass)) {
                return new Integer(value.toString());
            }
            return value;
        }
    }
}

