/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.extensions;

import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.extensions.EventConsumerThread;
import org.apache.maven.plugin.surefire.extensions.StreamFeeder;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.CommandReader;
import org.apache.maven.surefire.extensions.EventHandler;
import org.apache.maven.surefire.extensions.ForkChannel;
import org.apache.maven.surefire.extensions.util.CountdownCloseable;

final class LegacyForkChannel
extends ForkChannel {
    private CloseableDaemonThread commandReaderBindings;
    private CloseableDaemonThread eventHandlerBindings;

    LegacyForkChannel(@Nonnull ForkNodeArguments arguments) {
        super(arguments);
    }

    public void tryConnectToClient() {
    }

    public String getForkNodeConnectionString() {
        return "pipe://" + this.getArguments().getForkChannelId();
    }

    public int getCountdownCloseablePermits() {
        return 2;
    }

    public void bindCommandReader(@Nonnull CommandReader commands, WritableByteChannel stdIn) {
        ForkNodeArguments args = this.getArguments();
        String threadName = "commands-fork-" + args.getForkChannelId();
        this.commandReaderBindings = new StreamFeeder(threadName, stdIn, commands, args.getConsoleLogger());
        this.commandReaderBindings.start();
    }

    public void bindEventHandler(@Nonnull EventHandler<Event> eventHandler, @Nonnull CountdownCloseable countdownCloseable, ReadableByteChannel stdOut) {
        ForkNodeArguments args = this.getArguments();
        String threadName = "fork-" + args.getForkChannelId() + "-event-thread";
        this.eventHandlerBindings = new EventConsumerThread(threadName, stdOut, eventHandler, countdownCloseable, args);
        this.eventHandlerBindings.start();
    }

    public void disable() {
        if (this.eventHandlerBindings != null) {
            this.eventHandlerBindings.disable();
        }
        if (this.commandReaderBindings != null) {
            this.commandReaderBindings.disable();
        }
    }

    public void close() {
    }
}

