/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Named
@Singleton
class SurefireDependencyResolver {
    static final String PROVIDER_GROUP_ID = "org.apache.maven.surefire";
    private static final String[] PROVIDER_CLASSPATH_ORDER = new String[]{"surefire-junit3", "surefire-junit4", "surefire-junit47", "surefire-testng", "surefire-junit-platform", "surefire-api", "surefire-logger-api", "surefire-shared-utils", "common-java5", "common-junit3", "common-junit4", "common-junit48", "common-testng-utils"};
    private final RepositorySystem repositorySystem;

    @Inject
    SurefireDependencyResolver(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    static boolean isWithinVersionSpec(@Nullable Artifact artifact, @Nonnull String versionSpec) {
        if (artifact == null) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            try {
                return range.containsVersion(artifact.getSelectedVersion());
            }
            catch (NullPointerException e) {
                return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
            }
        }
        catch (InvalidVersionSpecificationException | OverConstrainedVersionException e) {
            throw new RuntimeException("Bug in plugin. Please report with stacktrace");
        }
    }

    Map<String, Artifact> resolvePluginDependencies(RepositorySystemSession session, List<RemoteRepository> repositories, Plugin plugin, Map<String, Artifact> pluginResolvedDependencies) throws MojoExecutionException {
        LinkedHashMap<String, Artifact> resolved = new LinkedHashMap<String, Artifact>();
        List pluginDependencies = plugin.getDependencies();
        for (Dependency dependency : pluginDependencies) {
            Set<Artifact> artifacts = this.resolveDependencies(session, repositories, RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)session.getArtifactTypeRegistry()));
            for (Artifact artifact : artifacts) {
                String key = artifact.getGroupId() + ":" + artifact.getArtifactId();
                Artifact resolvedPluginDependency = pluginResolvedDependencies.get(key);
                if (resolvedPluginDependency == null) continue;
                resolved.put(key, artifact);
            }
        }
        return resolved;
    }

    public Set<Artifact> resolveArtifacts(RepositorySystemSession session, List<RemoteRepository> repositories, Artifact artifact) throws MojoExecutionException {
        return this.resolveDependencies(session, repositories, RepositoryUtils.toDependency((Artifact)artifact, null));
    }

    private Set<Artifact> resolveDependencies(RepositorySystemSession session, List<RemoteRepository> repositories, org.eclipse.aether.graph.Dependency dependency) throws MojoExecutionException {
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(dependency);
            collectRequest.setRepositories(repositories);
            DependencyRequest request = new DependencyRequest();
            request.setCollectRequest(collectRequest);
            request.setFilter(DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}));
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(session, request);
            return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact).map(RepositoryUtils::toArtifact).collect(Collectors.toSet());
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Nonnull
    Set<Artifact> getProviderClasspath(RepositorySystemSession session, List<RemoteRepository> repositories, String providerArtifactId, String providerVersion) throws MojoExecutionException {
        Dependency provider = SurefireDependencyResolver.toProviderDependency(providerArtifactId, providerVersion);
        org.eclipse.aether.graph.Dependency dependency = RepositoryUtils.toDependency((Dependency)provider, (ArtifactTypeRegistry)session.getArtifactTypeRegistry());
        Set<Artifact> result = this.resolveDependencies(session, repositories, dependency);
        return SurefireDependencyResolver.orderProviderArtifacts(result);
    }

    @Nonnull
    Map<String, Artifact> getProviderClasspathAsMap(RepositorySystemSession session, List<RemoteRepository> repositories, String providerArtifactId, String providerVersion) throws MojoExecutionException {
        return ArtifactUtils.artifactMapByVersionlessId(this.getProviderClasspath(session, repositories, providerArtifactId, providerVersion));
    }

    private static Set<Artifact> orderProviderArtifacts(Set<Artifact> providerArtifacts) {
        LinkedHashSet<Artifact> orderedProviderArtifacts = new LinkedHashSet<Artifact>();
        for (String order : PROVIDER_CLASSPATH_ORDER) {
            Iterator<Artifact> providerArtifactsIt = providerArtifacts.iterator();
            while (providerArtifactsIt.hasNext()) {
                Artifact providerArtifact = providerArtifactsIt.next();
                if (!providerArtifact.getArtifactId().equals(order)) continue;
                orderedProviderArtifacts.add(providerArtifact);
                providerArtifactsIt.remove();
            }
        }
        orderedProviderArtifacts.addAll(providerArtifacts);
        return orderedProviderArtifacts;
    }

    private static Dependency toProviderDependency(String providerArtifactId, String providerVersion) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(PROVIDER_GROUP_ID);
        dependency.setArtifactId(providerArtifactId);
        dependency.setVersion(providerVersion);
        dependency.setType("jar");
        return dependency;
    }
}

