/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteXmlParser
extends DefaultHandler {
    private ReportTestSuite defaultSuite;
    private ReportTestSuite currentSuite;
    private Map<String, ReportTestSuite> classesToSuites;
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private StringBuffer currentElement;
    private ReportTestCase testCase;
    private boolean valid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ReportTestSuite> parse(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        Collection<ReportTestSuite> collection;
        File f = new File(xmlPath);
        FileInputStream fileInputStream = new FileInputStream(f);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        try {
            collection = this.parse(inputStreamReader);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStreamReader.close();
            fileInputStream.close();
            throw throwable;
        }
        inputStreamReader.close();
        fileInputStream.close();
        return collection;
    }

    public Collection<ReportTestSuite> parse(InputStreamReader stream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        this.valid = true;
        this.classesToSuites = new HashMap<String, ReportTestSuite>();
        saxParser.parse(new InputSource(stream), (DefaultHandler)this);
        if (this.currentSuite != this.defaultSuite && this.defaultSuite.getNumberOfTests() == 0) {
            this.classesToSuites.remove(this.defaultSuite.getFullClassName());
        }
        return this.classesToSuites.values();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block21: {
            if (!this.valid) {
                return;
            }
            try {
                if ("testsuite".equals(qName)) {
                    this.currentSuite = this.defaultSuite = new ReportTestSuite();
                    try {
                        Number time = this.numberFormat.parse(attributes.getValue("time"));
                        this.defaultSuite.setTimeElapsed(time.floatValue());
                    }
                    catch (NullPointerException npe) {
                        System.err.println("WARNING: no time attribute found on testsuite element");
                    }
                    if (attributes.getValue("group") != null && !"".equals(attributes.getValue("group"))) {
                        String packageName = attributes.getValue("group");
                        String name = attributes.getValue("name");
                        this.defaultSuite.setFullClassName(packageName + "." + name);
                    } else {
                        String fullClassName = attributes.getValue("name");
                        this.defaultSuite.setFullClassName(fullClassName);
                    }
                    this.classesToSuites.put(this.defaultSuite.getFullClassName(), this.defaultSuite);
                    break block21;
                }
                if ("testcase".equals(qName)) {
                    this.currentElement = new StringBuffer();
                    this.testCase = new ReportTestCase();
                    this.testCase.setName(attributes.getValue("name"));
                    String fullClassName = attributes.getValue("classname");
                    if (fullClassName != null) {
                        this.currentSuite = this.classesToSuites.get(fullClassName);
                        if (this.currentSuite == null) {
                            this.currentSuite = new ReportTestSuite();
                            this.currentSuite.setFullClassName(fullClassName);
                            this.classesToSuites.put(fullClassName, this.currentSuite);
                        }
                    }
                    this.testCase.setFullClassName(this.currentSuite.getFullClassName());
                    this.testCase.setClassName(this.currentSuite.getName());
                    this.testCase.setFullName(this.currentSuite.getFullClassName() + "." + this.testCase.getName());
                    String timeAsString = attributes.getValue("time");
                    Number time = 0;
                    if (timeAsString != null) {
                        time = this.numberFormat.parse(timeAsString);
                    }
                    this.testCase.setTime(time.floatValue());
                    if (this.currentSuite != this.defaultSuite) {
                        this.currentSuite.setTimeElapsed(time.floatValue() + this.currentSuite.getTimeElapsed());
                    }
                } else if ("failure".equals(qName)) {
                    this.testCase.addFailure(attributes.getValue("message"), attributes.getValue("type"));
                    this.currentSuite.setNumberOfFailures(1 + this.currentSuite.getNumberOfFailures());
                } else if ("error".equals(qName)) {
                    this.testCase.addFailure(attributes.getValue("message"), attributes.getValue("type"));
                    this.currentSuite.setNumberOfErrors(1 + this.currentSuite.getNumberOfErrors());
                } else if ("skipped".equals(qName)) {
                    String message = attributes.getValue("message");
                    this.testCase.addFailure(message != null ? message : "skipped", "skipped");
                    this.currentSuite.setNumberOfSkipped(1 + this.currentSuite.getNumberOfSkipped());
                } else if ("failsafe-summary".equals(qName)) {
                    this.valid = false;
                }
            }
            catch (ParseException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("testcase".equals(qName)) {
            this.currentSuite.getTestCases().add(this.testCase);
        } else if ("failure".equals(qName)) {
            Map<String, Object> failure = this.testCase.getFailure();
            failure.put("detail", this.parseCause(this.currentElement.toString()));
        } else if ("error".equals(qName)) {
            Map<String, Object> error = this.testCase.getFailure();
            error.put("detail", this.parseCause(this.currentElement.toString()));
        } else if ("time".equals(qName)) {
            try {
                Number time = this.numberFormat.parse(this.currentElement.toString());
                this.defaultSuite.setTimeElapsed(time.floatValue());
            }
            catch (ParseException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.valid) {
            return;
        }
        String s = new String(ch, start, length);
        if (!"".equals(s.trim())) {
            this.currentElement.append(s);
        }
    }

    private List<String> parseCause(String detail) {
        String fullName = this.testCase.getFullName();
        String name = fullName.substring(fullName.lastIndexOf(".") + 1);
        return this.parseCause(detail, name);
    }

    private List<String> parseCause(String detail, String compareTo) {
        StringTokenizer stringTokenizer = new StringTokenizer(detail, "\n");
        ArrayList<String> parsedDetail = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String lineString = stringTokenizer.nextToken().trim();
            parsedDetail.add(lineString);
            if (!lineString.contains(compareTo)) continue;
            break;
        }
        return parsedDetail;
    }

    public boolean isValid() {
        return this.valid;
    }
}

