/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.maven.shared.dependency.analyzer.ClassFileVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultAnnotationVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultClassVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultFieldVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultMethodVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.DefaultSignatureVisitor;
import org.apache.maven.shared.dependency.analyzer.asm.ResultCollector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyClassFileVisitor
implements ClassFileVisitor {
    private final ResultCollector resultCollector = new ResultCollector();

    @Override
    public void visitClass(String className, InputStream in) {
        try {
            ClassReader reader = new ClassReader(in);
            DefaultAnnotationVisitor annotationVisitor = new DefaultAnnotationVisitor(this.resultCollector);
            DefaultSignatureVisitor signatureVisitor = new DefaultSignatureVisitor(this.resultCollector);
            DefaultFieldVisitor fieldVisitor = new DefaultFieldVisitor(annotationVisitor, this.resultCollector);
            DefaultMethodVisitor mv = new DefaultMethodVisitor(annotationVisitor, signatureVisitor, this.resultCollector);
            DefaultClassVisitor classVisitor = new DefaultClassVisitor(signatureVisitor, annotationVisitor, fieldVisitor, mv, this.resultCollector);
            reader.accept((ClassVisitor)classVisitor, 0);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Unable to process: " + className);
        }
    }

    public Set<String> getDependencies() {
        return this.resultCollector.getDependencies();
    }
}

