/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.tfs.command;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.tfs.command.TfsCommand;
import org.apache.maven.scm.provider.tfs.command.consumer.ErrorStreamConsumer;
import org.apache.maven.scm.provider.tfs.command.consumer.FileListConsumer;

public class TfsCheckInCommand
extends AbstractCheckInCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository r, ScmFileSet f, String m, ScmVersion v) throws ScmException {
        ErrorStreamConsumer err;
        FileListConsumer fileConsumer;
        TfsCommand command = this.createCommand(r, f, m);
        int status = command.execute(fileConsumer = new FileListConsumer(), err = new ErrorStreamConsumer());
        if (status != 0 || err.hasBeenFed()) {
            return new CheckInScmResult(command.getCommandString(), "Error code for TFS checkin command - " + status, err.getOutput(), false);
        }
        return new CheckInScmResult(command.getCommandString(), fileConsumer.getFiles());
    }

    public TfsCommand createCommand(ScmProviderRepository r, ScmFileSet f, String m) {
        TfsCommand command = new TfsCommand("checkin", r, f, this.getLogger());
        command.addArgument("-noprompt");
        if (m != null && !m.equals("")) {
            command.addArgument("-comment:" + m + "");
        }
        command.addArgument(f);
        return command;
    }
}

